package com.huawei.hwmdemo.dependency;

import android.util.Log;

import com.huawei.hwmcommonui.ui.popup.dialog.base.BaseDialogBuilder;
import com.huawei.hwmconf.sdk.dependency.CLMNotifyHandler;
import com.huawei.hwmconf.sdk.dependency.ConfEndedReason;
import com.huawei.hwmconf.sdk.model.call.entity.CallInfo;
import com.huawei.hwmconf.sdk.model.call.entity.HWMP2PConfRecordInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfStatus;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.DemoActivity;
import com.huawei.hwmfoundation.utils.GsonUtil;
import com.huawei.hwmsdk.model.result.AudioQualityInfo;
import com.huawei.hwmsdk.model.result.MeetingInfo;
import com.huawei.hwmsdk.model.result.PoorNetWorkQualityInfo;

public class CustomNotifyHandler implements CLMNotifyHandler {
    final static String TAG = CustomNotifyHandler.class.getSimpleName();

    /**
     * 呼叫结束后，会收到该通知
     * @param callInfo 呼叫信息
     */

    @Override
    public void onCallEnded(CallInfo callInfo) {
        Log.i(TAG, "呼叫结束了");
        DemoUtil.showToast("CLMNotifyHandler 事件： onCallEnded 呼叫结束了");
    }

    @Override
    public void onConfDetailNotify(ConfInfo confInfo) {
        Log.i(TAG, "confInfo: confId" + confInfo.getConfId() + ", Subject:" + confInfo.getConfSubject() + ", CustomMsg is " + confInfo.getCustomInfo());
        DemoUtil.showToast("CLMNotifyHandler 事件： onConfDetailNotify " + confInfo.getConfSubject() + ", 是否外部会议 " + confInfo.isOtherCorpConf());
        SdkHelper.getInstance().setConfInfoCache(confInfo);
    }

    @Override
    public void onMeetingInfoChanged(MeetingInfo meetingInfo) {
        Log.i(TAG, "confInfo: confId" + meetingInfo.getConfId() + ", Subject:" + meetingInfo.getConfSubject());
        DemoUtil.showToast("onMeetingInfoChanged 事件： onMeetingInfoChanged " + meetingInfo.getConfSubject());
    }

    @Override
    public void onPoorNetworkQualityInfoNotify(PoorNetWorkQualityInfo poorNetWorkInfo) {
        Log.i(TAG, " poorNetWorkInfo : " + poorNetWorkInfo.getUserId() + " , "
            + " , " + poorNetWorkInfo.getIsLocal() + " , " + poorNetWorkInfo.getVideoStatus() + " , "
            + poorNetWorkInfo.getAudioStatus() + " , " + poorNetWorkInfo.getShareStatus());
        DemoUtil.showToast("CLMNotifyHandler 事件： onPoorNetworkQualityInfoNotify ");
    }

    @Override
    public void onAudioQualityNotify(AudioQualityInfo audioQualityInfo) {
        Log.i(TAG, " audioQualityInfo : sendQuality=" + audioQualityInfo.getSendQuality()
                + " , recvQuality=" + audioQualityInfo.getRecvQuality());
        DemoUtil.showToast("CLMNotifyHandler 事件： onAudioQualityNotify ");
    }

    /**
     * 会议结束该后，会收到通知
     * @param result 会议结束后的错误码
     */
    @Override
    public void onConfEnded(ConfEndedReason result) {
        SdkHelper.getInstance().clearConfInfoCache();
    }

    /**
     * 会议结束该后，会收到通知
     * @param retCode  会议结束后的错误码
     * @param desc  会议结束后的错误描述
     */
    @Override
    public void onConfEnded(int retCode, String desc) {
        DemoUtil.showToastDialog("endConf", retCode, desc, DemoActivity.getInstance());
        SdkHelper.getInstance().clearConfInfoCache();
    }

    @Override
    public void onLeaveConf(int result) {
        DemoUtil.showToast("CLMNotifyHandler 事件：onLeaveConf 离开了会议");
        SdkHelper.getInstance().clearConfInfoCache();
    }

    @Override
    public void onP2PConfRecord(HWMP2PConfRecordInfo p2pConfRecordInfo) {
        DemoUtil.showToast("CLMNotifyHandler 事件：onP2PConfRecord 呼叫结束上报通话信息 : " + GsonUtil.toJson(p2pConfRecordInfo));
        BaseDialogBuilder baseDialogBuilder = new BaseDialogBuilder(DemoActivity.getInstance());
        baseDialogBuilder
                .setMessage(GsonUtil.toJson(p2pConfRecordInfo))
                .addAction("确定",
                        (dialog, button, index) -> {
                            dialog.dismiss();
                        })
                .show();
    }

    @Override
    public void onConfStatusChanged(ConfStatus confStatus) {
        DemoUtil.showToast("CLMNotifyHandler 事件： onConfStatusChanged, " + confStatus.getDesc());
    }
}
