package com.huawei.hwmdemo.dependency.menu.audience;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.HandsUpOrDownMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.AllowSpeakerOrNotMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.AttendeeProfileMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.MuteOrUnmuteMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.PrivateChatMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RemoveMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RenameMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SetPaneListMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IAudienceMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMoreMenu;

import java.util.ArrayList;
import java.util.List;

public class CustomAudienceMenuHandle implements IAudienceMenuStrategy {
    @Override
    public List<IConfMenu> buildAudienceItemMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MuteOrUnmuteMenu());
        confMenus.add(new HandsUpOrDownMenu().setDarkIcon(true));
        confMenus.add(new PrivateChatMenu());
        confMenus.add(new RenameMenu());
        confMenus.add(new AllowSpeakerOrNotMenu());
        confMenus.add(new SetPaneListMenu());
        confMenus.add(new AttendeeProfileMenu());
        confMenus.add(new RemoveMenu());

        //【演示】增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }
}
