package com.huawei.hwmdemo.utils;

import android.content.Context;

import com.huawei.cloudlink.db.DBConfig;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.dependency.NeedCustomType;

public class ServerUtils {

    public static String getServerAddress(Context context) {
        if (DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)) {
            return ConfigConstant.INTERNATIONAL_SERVER_ADDRESS;
        }
        String address = PreferencesUtil.getStringPreference(context, ConfigConstant.KEY_SERVER_ADDRESS, null);
        if (address == null) {
            address = DBConfig.Default.getInstance().getServerAddress();
            PreferencesUtil.setStringPreferences(context, ConfigConstant.KEY_SERVER_ADDRESS, address);
        }
        return address;
    }

    public static String getServerPort(Context context) {
        return PreferencesUtil.getStringPreference(context, ConfigConstant.KEY_SERVER_PORT, DBConfig.Default.getInstance().getServerPort());
    }
}
