package com.huawei.hwmdemo.view;

import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.os.Build;
import android.os.Bundle;
import android.view.KeyEvent;

import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.FragmentActivity;

import com.huawei.hwmdemo.R;

public class BaseActivity extends FragmentActivity {

    private AlertDialog alertDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 35) {
            ViewCompat.setOnApplyWindowInsetsListener(getWindow().getDecorView(), (v, insets) -> {
                Insets innerPadding = insets.getInsets(WindowInsetsCompat.Type.systemBars());
                v.setPadding(innerPadding.left, innerPadding.top, innerPadding.right, innerPadding.bottom);
                return insets;
            });
            WindowCompat.getInsetsController(getWindow(), getWindow().getDecorView())
                    .setAppearanceLightStatusBars(true);
        }
    }

    public void dismissLoading() {
        if (null != alertDialog && alertDialog.isShowing()) {
            if (!isFinishing()) {
                alertDialog.dismiss();
            }
        }
    }

    public void showLoading() {
        if (alertDialog == null) {
            alertDialog = new AlertDialog.Builder(this).create();
            alertDialog.getWindow().setBackgroundDrawable(new ColorDrawable());
            alertDialog.setCancelable(false);
            alertDialog.setOnKeyListener(new DialogInterface.OnKeyListener() {
                @Override
                public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                    return keyCode == KeyEvent.KEYCODE_SEARCH || keyCode == KeyEvent.KEYCODE_BACK;
                }
            });
            alertDialog.setCanceledOnTouchOutside(false);

        }
        if (!isFinishing()) {
            alertDialog.show();
            alertDialog.setContentView(R.layout.loading_alert);
        }
    }
}
