package com.huawei.hwmdemo.view.scheme;

import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.Switch;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.DialogFragment;

import com.huawei.clpermission.CLPermConstant;
import com.huawei.hwmconf.presentation.util.PermissionUtil;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

public class LinkJoinFragment extends DialogFragment {
    public final static String TAG = LinkJoinFragment.class.getSimpleName();
    View rootView;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.link_join_conf, container, false);

        Button joinBtn = rootView.findViewById(R.id.btn_6);
        joinBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                linkJoinMeeting(v);
            }
        });
        return rootView;
    }

    public void linkJoinMeeting(View view) {
        TextView addressView = rootView.findViewById(R.id.anonymous_server_address);
        String serverAddress =  addressView.getText().toString();
        if (serverAddress.equals("")) {
            serverAddress =  addressView.getHint().toString();
        }
        TextView portView = rootView.findViewById(R.id.anonymous_server_port);
        String portString = portView.getText().toString();
        if (portString.equals("")) {
            portString = portView.getHint().toString();
        }
        TextView confIdView = rootView.findViewById(R.id.anonymous_conf_id);
        String confId = confIdView.getText().toString();
        Switch micSwitch = rootView.findViewById(R.id.switch_open_mic);
        boolean openMic = micSwitch.isChecked() && PermissionUtil.hasPermission(CLPermConstant.Type.AUDIO);
        Switch cameraSwitch = rootView.findViewById(R.id.switch_open_camera);
        boolean openCamera = cameraSwitch.isChecked() && PermissionUtil.hasPermission(CLPermConstant.Type.CAMERA);
        TextView confEnterCodeView = rootView.findViewById(R.id.anonymous_enter_code);
        String enterCode = confEnterCodeView.getText().toString();
        TextView nameView = rootView.findViewById(R.id.anonymous_name);
        String name = nameView.getText().toString();
        if (name.equals("")) {
            name = nameView.getHint().toString();
        }
        if (!confId.isEmpty() && !serverAddress.isEmpty() && !portString.isEmpty()) {
            LinkJoinParam param = new LinkJoinParam();
            param.serverAddress = serverAddress;
            param.portString = portString;
            param.confId = confId;
            param.enterCode = enterCode;
            param.name = name;
            param.openMic = openMic;
            param.openCamera = openCamera;

            doLinkJoin(param);

        } else {
            Toast.makeText(this.getContext(),"必需参数为空", Toast.LENGTH_SHORT).show();
        }
    }

    public void doLinkJoin(@NonNull LinkJoinParam param) {
        try {
            Uri.Builder builder = new Uri.Builder()
                .scheme("cloudlink")
                .authority("welinksoftclient")
                .path("h5page")
                .appendQueryParameter("page", "joinConfByLink")
                .appendQueryParameter("server_url", param.serverAddress)
                .appendQueryParameter("port", param.portString)
                .appendQueryParameter("conf_id", param.confId)
                .appendQueryParameter("enter_code", param.enterCode)
                .appendQueryParameter("name", param.name)
                .appendQueryParameter("open_mic", String.valueOf(param.openMic))
                .appendQueryParameter("open_camera", String.valueOf(param.openCamera));
            DemoUtil.openCloudLinkWithURL(getActivity(), builder.toString());
        } catch (UnsupportedOperationException e) {
            Log.e(TAG, e.getMessage());
        }

    }

    public static class LinkJoinParam {
        public String serverAddress;
        public String portString;
        public String confId;
        public String enterCode;
        public String name;
        public boolean openMic;
        public boolean openCamera;
    }
}
