package com.huawei.hwmdemo.view.scheme;

import android.app.AlertDialog;

import androidx.fragment.app.DialogFragment;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.CommonUiConfig;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseListFragment;
import com.huawei.hwmdemo.view.sdk.CapabilitiesConfigStateFragment;
import com.huawei.hwmlogger.HCLog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 状态类API接口调用Demo
 */
public class StateApiFragment extends BaseListFragment {
    private static final String TAG = StateApiFragment.class.getSimpleName();
    private List<String> titles = Arrays.asList("与会者列表","观众列表","共享权限", "查询本端共享状态", "停止本端共享", "自定义功能启用或屏蔽", "查询会议是否锁定");
    private List<Class> fragments = Arrays.asList(
            null,
            null, null, null, null, null, null);
    private final List<ApiPageModel> models = new ArrayList<>();

    @Override
    public List<ApiPageModel> getItems() {
        models.clear();
        for (int i = 0; i < titles.size(); i++) {
            ApiPageModel model = new ApiPageModel();
            model.name = titles.get(i);
            model.page = fragments.get(i);
            if ("共享权限".equals(model.name)) {
                model.isShowCheck = true;
                model.checkStyle = CommonUiConfig.getInstance().isHasSharePermission();
            }
            models.add(model);
        }

        return models;
    }

    @Override
    public void handleItemClick(int position, ApiPageModel data) {
        if (position == 0) {
            showAttendeeDialog(HWMBizSdk.getBizOpenApi().getAttendeeList(), true);
        } else if (position == 1) {
            showAttendeeDialog(HWMBizSdk.getBizOpenApi().getAudienceList(), false);
        } else if (position == 2) {
            models.get(position).checkStyle = !models.get(position).checkStyle;
            setShareScreenPermission(models.get(position).checkStyle);
        } else if (position == 3) {
            boolean isSelfSharing = HWMBizSdk.getBizOpenApi().getSelfShareState();
            DemoUtil.showToast(  "本端是否正在共享: " + isSelfSharing);
        } else if (position == 4) {
            HWMBizSdk.getBizOpenApi().stopShare("DemoTest");
            DemoUtil.showToast(  "call stopShare");
        } else if (position == 5) {
            DialogFragment fragment = new CapabilitiesConfigStateFragment();
            fragment.show(getActivity().getSupportFragmentManager(), null);
        } else if (position == 6) {
            boolean confIsLocked = HWMBizSdk.getBizOpenApi().getConfIsLocked();
            DemoUtil.showToast(  "会议是否锁定: " + confIsLocked);
        }
    }

    private void showAttendeeDialog(List<AttendeeModel> list, boolean isAttendee) {
        String title = isAttendee ? "与会者" : "观众";
        if (list == null || list.size() == 0) {
            DemoUtil.showToast(title + "人数：0");
            return;
        }
        final String[] items = new String[list.size()];
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i) != null) {
                HCLog.i(TAG, "name " + list.get(i).getName() + " ThirdUserId " + list.get(i).getThirdUserId()
                        + " State " + (list.get(i).getState() != null ? list.get(i).getState().getDescription().split(":")[1] : "")
                        + " AccountId " + list.get(i).getAccountId());
                items[i] = list.get(i).getName() + " " + list.get(i).getAliasCN() + " " + list.get(i).getAliasEN() + " " + list.get(i).getThirdUserId()
                        + " " + (list.get(i).getState() != null ? list.get(i).getState().getDescription().split(":")[1] : "")
                        + " " + list.get(i).getAccountId() + " " + list.get(i).getExtendedField() + " " + list.get(i).getRealNameAccount();
            } else {
                items[i] = "";
            }
        }
        AlertDialog.Builder listDialog = new AlertDialog.Builder(getContext());
        listDialog.setTitle(title + "列表");
        listDialog.setItems(items, (dialog, pos) -> dialog.dismiss());
        listDialog.show();
    }

    private void setShareScreenPermission(boolean hasPermission) {
        HWMBizSdk.getBizOpenApi().setShareScreenPermission(hasPermission);
        if (mAdapter != null) {
            mAdapter.notifyDataSetChanged();
        }
    }
}
