
package com.huawei.hwmdemo.view.sdk;

import android.content.Context;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;

import java.util.ArrayList;
import java.util.List;

/**
 * 会议详情中 与会者列表详情
 */
public class AttendeeListInfosFragment extends BaseDialogFragment {

    private View rootView;

    private RecyclerView recyclerView;

    private List<AttendeeModel> items = new ArrayList<>();

    public void init(List<AttendeeModel> items) {
        if (items != null) {
            this.items = items;
        }
    }

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.fragment_attendee_list_infos, container, false);
        recyclerView = rootView.findViewById(R.id.attendee_list_infos);
        return rootView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        recyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        AttendeeListAdapter adapter = new AttendeeListAdapter(getContext(), items);
        recyclerView.setAdapter(adapter);
    }

    private static class AttendeeListAdapter extends RecyclerView.Adapter<ViewHolder> {
        private final List<AttendeeModel> items;
        private final Context context;

        public AttendeeListAdapter(Context context, List<AttendeeModel> items) {
            this.context = context;
            this.items = items;
        }

        @NonNull
        @Override
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            View view = LayoutInflater.from(context).inflate(android.R.layout.simple_list_item_1, parent, false);
            return new ViewHolder(view);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
            AttendeeModel attendeeModel = items.get(position);
            String attendee = "attendee{" +
                    "name=" + attendeeModel.getName() +
                    ", aliasCN=" + attendeeModel.getAliasCN() +
                    ", aliasEN=" + attendeeModel.getAliasEN() +
                    ", thirdUserId=" + attendeeModel.getThirdUserId() +
                    ", number=" + attendeeModel.getNumber() +
                    ", corpId=" + attendeeModel.getOrgId() +
                    ", extendedField=" + attendeeModel.getExtendedField() +
                    '}';
            holder.textView.setText(attendee);
        }

        @Override
        public int getItemCount() {
            return items.size();
        }
    }

    private static class ViewHolder extends RecyclerView.ViewHolder {
        public TextView textView;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            textView = itemView.findViewById(android.R.id.text1);
        }
    }
}
