package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Switch;

import androidx.annotation.NonNull;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.constant.Constants;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;

public class CameraOrientSettingFragment extends BaseDialogFragment {
    public final static String TAG = CameraOrientSettingFragment.class.getSimpleName();
    private View rootView;
    private EditText cameraOrient;

    private Switch cameraDirection;

    private Button ensure;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.camera_orient_setting, container, false);

        cameraOrient = rootView.findViewById(R.id.camera_orient);
        cameraDirection = rootView.findViewById(R.id.switch_is_front_camera);
        ensure = rootView.findViewById(R.id.btn_ensure);

        ensure.setOnClickListener(v -> {
            int orient = 0;
            int direction = 0;

            String str = cameraOrient.getText().toString();
            if (TextUtils.isDigitsOnly(str)) {
                orient = Integer.parseInt(str);
            }
            direction = cameraDirection.isChecked() ? 1 : 0;
            HWMBizSdk.getBizOpenApi().setCameraOrient(orient, direction, true);
            PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, Constants.CAMERA_DIRECTION, orient, Utils.getApp());
            dismiss();
            DemoUtil.showToast("设置成功");
        });

        return rootView;
    }
}
