package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.CompoundButton;
import android.widget.Switch;

import androidx.annotation.NonNull;

import com.google.gson.Gson;
import com.huawei.cloudlink.openapi.model.HWMEnableFeatureType;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.utils.PreferencesUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmlogger.HCLog;

import java.util.List;

public class CapabilitiesConfigFragment extends BaseDialogFragment {

    private final static String TAG = CapabilitiesConfigFragment.class.getSimpleName();

    private List<HWMEnableFeatureType> checkedCapabilities;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        View rootView = inflater.inflate(R.layout.sdk_capabilities_config, container, false);
        initData();
        initView(rootView);
        return rootView;
    }

    private void initData() {
        checkedCapabilities = DemoUtil.queryCheckedCapabilities();
    }

    private void initView(View rootView) {
        Switch disableBreakoutSwitch = rootView.findViewById(R.id.disable_breakout_feature);
        boolean isChecked = isChecked(HWMEnableFeatureType.HWM_FEATURE_TYPE_BREAKOUT_CONF);
        disableBreakoutSwitch.setChecked(isChecked);
        disableBreakoutSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                setCheckedFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_BREAKOUT_CONF, isChecked);
            }
        });

        Switch enableConfirmRecordSwitch = rootView.findViewById(R.id.enable_confirm_record);
        isChecked = isChecked(HWMEnableFeatureType.HWM_FEATURE_TYPE_CONFIRM_RECORD);
        enableConfirmRecordSwitch.setChecked(isChecked);
        enableConfirmRecordSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                setCheckedFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_CONFIRM_RECORD, isChecked);
            }
        });

        Switch enableSaveName = rootView.findViewById(R.id.enable_save_name_when_anonymous_join);
        isChecked = isChecked(HWMEnableFeatureType.HWM_FEATURE_TYPE_SAVE_NICK_NAME_WHEN_ANONYMOUS_JOIN);
        enableSaveName.setChecked(isChecked);
        enableSaveName.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                setCheckedFeature(HWMEnableFeatureType.HWM_FEATURE_TYPE_SAVE_NICK_NAME_WHEN_ANONYMOUS_JOIN, isChecked);
            }
        });


        Switch disableVirtualBackground = rootView.findViewById(R.id.disable_virtual_background);
        isChecked = isChecked(HWMEnableFeatureType.HWM_ENABLE_FEATURE_TYPE_VIRTUAL_BACKGROUND);
        disableVirtualBackground.setChecked(isChecked);
        disableVirtualBackground.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                setCheckedFeature(HWMEnableFeatureType.HWM_ENABLE_FEATURE_TYPE_VIRTUAL_BACKGROUND, isChecked);
            }
        });
    }

    private boolean isChecked(HWMEnableFeatureType type) {
        for (HWMEnableFeatureType value : checkedCapabilities) {
            if (type == value) {
                return true;
            }
        }
        return false;
    }

    private void setCheckedFeature(HWMEnableFeatureType type, boolean isChecked) {
        if (!isChecked) {
            checkedCapabilities.remove(type);
            save();
            return;
        }

        boolean found = false;
        for (HWMEnableFeatureType value : checkedCapabilities) {
            if (type == value) {
                found = true;
            }
        }

        if (!found) {
            checkedCapabilities.add(type);
            save();
        }
    }

    private void save() {
        String toSavedConfig = new Gson().toJson(checkedCapabilities);
        PreferencesUtil.asyncSave(DemoUtil.getApplication(), NeedCustomType.FEATURE_CONFIG,
            toSavedConfig);
        HCLog.d(TAG, "save " + toSavedConfig);
    }
}
