package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.hwmconf.presentation.model.HWMIncomingAnswerType;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;

public class InComingConfigFragment extends BaseDialogFragment {
    public final static String TAG = InComingConfigFragment.class.getSimpleName();
    private View rootView;
    private RadioGroup callGroup;
    private RadioGroup confGroup;
    private int callType;
    private int confType;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_incoming, container, false);

        initCallRadioGroup();
        initConfRadioGroup();

        return rootView;
    }

    private void initCallRadioGroup() {
        callGroup = rootView.findViewById(R.id.call_group);
        callType = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CALL,
                HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), DemoUtil.getApplication());
        if (HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType() == callType) {
            ((RadioButton)rootView.findViewById(R.id.call_incoming_normal)).setChecked(true);
        } else if (HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType() == callType) {
            ((RadioButton)rootView.findViewById(R.id.call_incoming_auto_reject)).setChecked(true);
        } else {
            ((RadioButton)rootView.findViewById(R.id.call_incoming_auto_accept)).setChecked(true);
        }
        callGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.call_incoming_normal) {
                    callType = HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType();
                } else if (id == R.id.call_incoming_auto_reject) {
                    callType = HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType();
                } else {
                    callType = HWMIncomingAnswerType.HWM_INCOMING_AUTO_ANSWER.getType();
                }
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CALL,
                        callType, DemoUtil.getApplication());
            }
        });
    }

    private void initConfRadioGroup() {
        confGroup = rootView.findViewById(R.id.conf_group);
        confType = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF,
                HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), DemoUtil.getApplication());
        if (HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType() == confType) {
            ((RadioButton)rootView.findViewById(R.id.conf_incoming_normal)).setChecked(true);
        } else if (HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType() == confType) {
            ((RadioButton)rootView.findViewById(R.id.conf_incoming_auto_reject)).setChecked(true);
        } else if (HWMIncomingAnswerType.HWM_INCOMING_AUTO_ANSWER.getType() == confType) {
            ((RadioButton)rootView.findViewById(R.id.conf_incoming_auto_accept)).setChecked(true);
        } else if (HWMIncomingAnswerType.HWM_INCOMING_CUSTOM.getType() == confType) {
            ((RadioButton)rootView.findViewById(R.id.conf_incoming_custom)).setChecked(true);
        }
        confGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.conf_incoming_normal) {
                    confType = HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType();
                } else if (id == R.id.conf_incoming_auto_reject) {
                    confType = HWMIncomingAnswerType.HWM_IMCOMING_AUTO_DECLINE.getType();
                } else if (id == R.id.conf_incoming_auto_accept) {
                    confType = HWMIncomingAnswerType.HWM_INCOMING_AUTO_ANSWER.getType();
                } else if (id == R.id.conf_incoming_custom) {
                    confType = HWMIncomingAnswerType.HWM_INCOMING_CUSTOM.getType();
                }
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF,
                        confType, DemoUtil.getApplication());
            }
        });
    }

}
