package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.Switch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmlogger.HCLog;

public class IncomingNotificationFragment extends BaseDialogFragment {

    private static final String TAG = IncomingNotificationFragment.class.getSimpleName();
    private View mRootView;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container,
        @Nullable Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        mRootView = inflater.inflate(R.layout.incoming_notice_dialog, container, false);
        Switch mSwitchVibrate = mRootView.findViewById(R.id.notice_vibrate);
        Switch mSwitchRing = mRootView.findViewById(R.id.notice_ring);
        Button mSaveBtn = mRootView.findViewById(R.id.notice_save);
        mSaveBtn.setOnClickListener(v -> {
            changeInComingNotice(mSwitchVibrate.isChecked(), mSwitchRing.isChecked());
        });
        return mRootView;
    }

    private void changeInComingNotice(boolean isOpenVibrate, boolean isOpenRing) {
        Log.i(TAG, " isOpenVibrate:" + isOpenVibrate + ", isOpenRing:" + isOpenRing);
        HWMSdk.getOpenApi(HWMBizSdk.getApplication()).changeInComingNotice(isOpenVibrate, isOpenRing, new HwmCallback<Boolean>() {
            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.i(TAG,"changeInComingNotice onFailed" + retCode + " " + desc);
                dismissLoading();
                dismiss();
                String err = ErrorMessageFactory.create(retCode);
                if (!TextUtils.isEmpty(err)) {
                    desc = err;
                }
                DemoUtil.showToastDialog("changeInComingNotice", retCode, desc);
            }

            @Override
            public void onSuccess(Boolean aBoolean) {
                dismissLoading();
                dismiss();
            }
        });
    }
}
