package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.cloudlink.openapi.api.param.LanguageType;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;

public class LanguageSettingFragment extends BaseDialogFragment {
    public final static String TAG = LanguageSettingFragment.class.getSimpleName();

    private RadioGroup mLanguageRadioGroup;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.language_setting_layout, container, false);
        mLanguageRadioGroup = vRoot.findViewById(R.id.rg_language_type);
        initViews();
        vRoot.findViewById(R.id.save_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                handleSaveButtonClicked();
                dismiss();
            }
        });
        return vRoot;
    }

    private void initViews() {

        String language = DemoUtil.getCustomLanguage();
        if (TextUtils.equals(language, "zh-CN")) {
            mLanguageRadioGroup.check(R.id.rb_zh);
        } else if (TextUtils.equals(language, "en")) {
            mLanguageRadioGroup.check(R.id.rb_en);
        } else if (TextUtils.equals(language, "ar")) {
            mLanguageRadioGroup.check(R.id.rb_ar);
        }
    }

    private void handleSaveButtonClicked() {
        String language = "";
        int checkedRadioButtonId = mLanguageRadioGroup.getCheckedRadioButtonId();
        if (checkedRadioButtonId == R.id.rb_zh) {
            language = "zh-CN";
            HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_CN_ZH, "zh-CN");
        } else if (checkedRadioButtonId == R.id.rb_en) {
            language = "en";
            HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_EN, "en");
        } else if (checkedRadioButtonId == R.id.rb_ar) {
            language = "ar";
            HWMSdk.getOpenApi(DemoUtil.getApplication()).setLanguage(LanguageType.LANGUAGE_TYPE_CUSTOMIZED, "ar");
        }
        DemoUtil.settCustomLanguage(language);
    }

}
