package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RadioButton;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;

public class SetInitTypeFragment extends BaseDialogFragment {

    private View rootView;

    private Button setBtn;

    private RadioButton initRB;

    private RadioButton initAsyncRB;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        rootView = inflater.inflate(R.layout.sdk_set_init_type, container, false);
        setBtn = rootView.findViewById(R.id.set_btn);
        setBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                boolean isAsyncInit = initAsyncRB.isChecked();
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.ASYNC_INIT_SDK_CONFIG, isAsyncInit, DemoUtil.getApplication());
                dismiss();
                showLoading();
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    dismissLoading();
                    DemoUtil.restartApplication();
                }, 1500L);
            }
        });

        initRB = rootView.findViewById(R.id.init_rb);
        initAsyncRB = rootView.findViewById(R.id.init_async_rb);

        boolean isAsyncInit = DemoUtil.needCustom(NeedCustomType.ASYNC_INIT_SDK_CONFIG);
        initRB.setChecked(!isAsyncInit);
        initAsyncRB.setChecked(isAsyncInit);

        return rootView;
    }
}
