package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.hwmconf.presentation.model.HWMWatermarkControlOption;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;

public class WaterMarkControlOptionConfigFragment extends BaseDialogFragment {
    public final static String TAG = WaterMarkControlOptionConfigFragment.class.getSimpleName();
    private View rootView;
    private RadioGroup controlOptionRG;
    private int controlOption;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_custom_water_mark, container, false);
        initData();
        return rootView;
    }

    private void initData() {
        controlOptionRG = rootView.findViewById(R.id.control_option_group);
        controlOption = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, ConfigConstant.KEY_CUSTOM_WATER_MARK_CONTROL_OPTION_KEY,
                HWMWatermarkControlOption.HWMWatermarkControlOptionNormal.getType(), DemoUtil.getApplication());

        if (HWMWatermarkControlOption.HWMWatermarkControlOptionForceOn.getType() == controlOption) {
            ((RadioButton) rootView.findViewById(R.id.control_option_force_on)).setChecked(true);
        } else if (HWMWatermarkControlOption.HWMWatermarkControlOptionForceOff.getType() == controlOption) {
            ((RadioButton) rootView.findViewById(R.id.control_option_force_off)).setChecked(true);
        } else {
            ((RadioButton) rootView.findViewById(R.id.control_option_default)).setChecked(true);
        }

        controlOptionRG.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.control_option_force_on) {
                    controlOption = HWMWatermarkControlOption.HWMWatermarkControlOptionForceOn.getType();
                } else if (id == R.id.control_option_force_off) {
                    controlOption = HWMWatermarkControlOption.HWMWatermarkControlOptionForceOff.getType();
                } else {
                    controlOption = HWMWatermarkControlOption.HWMWatermarkControlOptionNormal.getType();
                }
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, ConfigConstant.KEY_CUSTOM_WATER_MARK_CONTROL_OPTION_KEY, controlOption, DemoUtil.getApplication());
            }
        });

    }
}
