package com.huawei.hwmdemo.view.sdkconfig.menu;

import com.huawei.hwmdemo.delegate.DelegateHolder;
import com.huawei.hwmdemo.model.MenuGroup;

import java.util.List;

public class FloatingMenuConfigFragment extends MenuConfigFragment {

    @Override
    protected void initData() {
        List<MenuGroup> floatingMenuFeatures = DelegateHolder.getHwmUiDelegate().getFloatingMenuFeatures();
        for (MenuGroup floating : floatingMenuFeatures) {
            addGroupData(floating.getName(), floating.getTag(), floating.getMenus());
        }
    }

    @Override
    public String getName() {
        return "悬浮窗会议菜单栏";
    }

    @Override
    protected String getMenuHandleName() {
        return DelegateHolder.getHwmUiDelegate().getFloatingMenuHandle();
    }
}
