package com.huawei.hwmdemo.view.sdkconfig.menu;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MenuConfigFragment extends Fragment {

    private View mRootView;
    private RecyclerView mRecyclerView;
    private MenuConfigRecyclerViewAdapter mAdapter;

    private Map<String, int[]> group = new HashMap<>();

    private List<Object> data = new ArrayList<>();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (mRootView == null) {
            mRootView = inflater.inflate(R.layout.menu_config_list, container, false);
            initData();
            mRecyclerView = mRootView.findViewById(R.id.main_list);
            mRecyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
            mAdapter = new MenuConfigRecyclerViewAdapter(data, getMenuHandleName(), group);
            mRecyclerView.setAdapter(mAdapter);
            //设置分割线
            mRecyclerView.addItemDecoration(DemoUtil.getRecyclerViewDivider(getContext(), R.drawable.main_recycler_decoration));
        } else {
            ViewGroup parent = (ViewGroup) mRootView.getParent();
            if (parent != null) {
                parent.removeView(mRootView);
            }
        }
        return mRootView;
    }

    public void addGroupData(String groupName, String groupTag, List<IConfMenu> menus) {
        data.add(groupName);
        data.addAll(menus);
        group.put(groupTag, new int[] {data.size() - 1 - menus.size(), data.size() - 1});
    }

    protected abstract void initData();

    public abstract String getName();

    protected abstract String getMenuHandleName();
}
