package com.huawei.hwmdemo.view.sdkconfig.menu;


import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MenuConfigRecyclerViewAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {


    private static final int NORMAL_TYPE = 0;

    private static final int TITLE_TYPE = 1;

    private List<Object> list;
    private Map<String, int[]> group;

    private DisabledMenuConfig disabledMenuConfig = DemoUtil.getDisabledMenuConfig();

    private String handleName;

    @Override
    public int getItemViewType(int position) {
        Object item = list.get(position);
        if (item instanceof IConfMenu) {
            return NORMAL_TYPE;
        } else {
            return TITLE_TYPE;
        }
    }


    public MenuConfigRecyclerViewAdapter(List<Object> list, String handleName, Map<String, int[]> group) {
        this.list = list;
        this.handleName = handleName;
        this.group = group;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == NORMAL_TYPE) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.menu_config_item, parent, false);
            NormalViewHolder normalViewHolder = new NormalViewHolder(view);
            return normalViewHolder;
        } else if (viewType == TITLE_TYPE) {
            View view = LayoutInflater.from(parent.getContext()).inflate(R.layout.menu_config_title, parent, false);
            return new TitleViewHolder(view);
        }
        return null;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        Object data = list.get(position);
        if (holder instanceof NormalViewHolder) {
            bindNormalView(position, (IConfMenu) data, (NormalViewHolder) holder);
        } else if (holder instanceof TitleViewHolder) {
            bindTitleView((String) data, (TitleViewHolder) holder);
        }

    }

    private void bindNormalView(int position, IConfMenu data, NormalViewHolder holder) {
        if (data.getClass().getSimpleName().contains("AudienceMicMenu")) {
            holder.mText.setText("静音（观众角色）");
        } else if (data.getClass().getSimpleName().contains("MicMenu")) {
            holder.mText.setText("静音");
        } else {
            holder.mText.setText(DemoUtil.getResContext().getString(data.getTextRes()));
        }
        holder.mCheckBox.setChecked(!disabled(position, data));
        holder.itemView.setOnClickListener(new MyOnClickListener(position, data));
    }

    private boolean disabled(int position, IConfMenu confMenu) {
        if (!disabledMenuConfig.configMap.containsKey(handleName)) {
            return false;
        }
        if (disabledMenuConfig.configMap.get(handleName).disabledMenuGroup == null) {
            return false;
        }
        HashSet<String> groupMenuConfig = disabledMenuConfig.configMap.get(handleName).disabledMenuGroup.get(getGroupTag(position));
        return groupMenuConfig != null && groupMenuConfig.contains(confMenu.getClass().getName());
    }

    private void reverseDisableState(int position, IConfMenu confMenu) {
        boolean disabled = !disabled(position, confMenu);

        if (!disabledMenuConfig.configMap.containsKey(handleName)) {
            disabledMenuConfig.configMap.put(handleName, new DisabledMenuConfig.DisabledMenuHandleConfig());
        }
        if (disabledMenuConfig.configMap.get(handleName).disabledMenuGroup == null) {
            disabledMenuConfig.configMap.get(handleName).disabledMenuGroup = new HashMap<>();
        }


        String groupTag = getGroupTag(position);
        if (!disabledMenuConfig.configMap.get(handleName).disabledMenuGroup.containsKey(groupTag)) {
            disabledMenuConfig.configMap.get(handleName).disabledMenuGroup.put(groupTag, new HashSet<>());
        }
        if (disabled) {
            disabledMenuConfig.configMap.get(handleName).disabledMenuGroup.get(groupTag).add(confMenu.getClass().getName());
        } else {
            disabledMenuConfig.configMap.get(handleName).disabledMenuGroup.get(groupTag).remove(confMenu.getClass().getName());
        }

    }

    private String getGroupTag(int position) {
        Iterator<Map.Entry<String, int[]>> iterator = group.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, int[]> entry = iterator.next();
            if (position >= entry.getValue()[0] && position <= entry.getValue()[1]) {
                return entry.getKey();
            }
        }
        return "";
    }

    private void bindTitleView(String data, TitleViewHolder holder) {
        holder.mText.setText(data);
    }

    @Override
    public int getItemCount() {
        return list.size();
    }

    class NormalViewHolder extends RecyclerView.ViewHolder {
        TextView mText;

        CheckBox mCheckBox;

        NormalViewHolder(View itemView) {
            super(itemView);
            mText = itemView.findViewById(R.id.main_item_text);
            mCheckBox = itemView.findViewById(R.id.main_item_checkbox);
        }
    }

    class TitleViewHolder extends RecyclerView.ViewHolder {
        TextView mText;

        TitleViewHolder(View itemView) {
            super(itemView);
            mText = itemView.findViewById(R.id.main_item_text);
        }
    }

    private class MyOnClickListener implements View.OnClickListener {
        private int position;

        private IConfMenu data;

        public MyOnClickListener(int position, IConfMenu data) {
            this.position = position;
            this.data = data;
        }

        @Override
        public void onClick(View v) {
            reverseDisableState(position, data);
            notifyItemChanged(position);
        }
    }
}