package com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle;

import com.huawei.hwmdemo.menu.ConfVideoToolbarMenuCreator;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMenu;
import com.huawei.hwmdemo.dependency.menu.item.VisionPairCodeMenu;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.utils.MenuHelper;

import java.util.ArrayList;
import java.util.List;

/**
 * 演示大屏自定义"视频会议"场景下的toolbar菜单
 */
public class CustomVisionConfVideoToolbarHandle implements IToolbarMenuStrategy {

    @Override
    public List<IConfMenu> buildMenuItems() {
        List<IConfMenu> confMenus = ConfVideoToolbarMenuCreator.createConfVideoToolbarMenus(DemoUtil.getApplication(), MenuHelper.isCustomAddAttendeeMenuSupported());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildMoreMenuItems() {
        List<IConfMenu> confMenus = ConfVideoToolbarMenuCreator.createConfVideoToolbarMoreMenus(DemoUtil.getApplication(), MenuHelper.isCustomAddAttendeeMenuSupported());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    /**
     * 大屏不支持自定义设置，直接返回空集合
     */
    @Override
    public List<IConfMenu> buildSettingMenuItems() {
        return new ArrayList<>();
    }
}
