package com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle;

import com.huawei.hwmdemo.menu.ConfWebinarToolbarMenuCreator;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMenu;
import com.huawei.hwmdemo.dependency.menu.item.VisionPairCodeMenu;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmsdk.NativeSDK;
import com.huawei.hwmsdk.enums.ConfRole;

import java.util.ArrayList;
import java.util.List;

public class CustomVisionConfWebinarToolbarHandle implements IToolbarMenuStrategy {

    @Override
    public List<IConfMenu> buildMenuItems() {

        if (!NativeSDK.getConfMgrApi().isInConf()) {
            return buildAllMenuItems();
        }

        if (NativeSDK.getConfStateApi().getSelfRole() == ConfRole.ROLE_AUDIENCE) {
            return buildAudienceMenuItems();
        }

        if (NativeSDK.getConfStateApi().getSelfRole() == ConfRole.ROLE_HOST) {
            return buildHostMenuItems();
        }

        return buildAttendeeMenuItems();
    }

    private List<IConfMenu> buildAllMenuItems() {
        List<IConfMenu> confMenus = ConfWebinarToolbarMenuCreator.createConfWebinarToolbarAllMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    private List<IConfMenu> buildAudienceMenuItems() {
        List<IConfMenu> confMenus = ConfWebinarToolbarMenuCreator.createConfWebinarToolbarAudienceMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    private List<IConfMenu> buildAttendeeMenuItems() {
        List<IConfMenu> confMenus = ConfWebinarToolbarMenuCreator.createConfWebinarToolbarAttendeeMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    private List<IConfMenu> buildHostMenuItems() {
        List<IConfMenu> confMenus = ConfWebinarToolbarMenuCreator.createConfWebinarToolbarHostMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildMoreMenuItems() {
        List<IConfMenu> confMenus = ConfWebinarToolbarMenuCreator.createConfWebinarToolbarMoreMenus(DemoUtil.getApplication());
        confMenus.add(new VisionPairCodeMenu());
        //增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    /**
     * 大屏不支持自定义设置，直接返回空集合
     */
    @Override
    public List<IConfMenu> buildSettingMenuItems() {
        return new ArrayList<>();
    }
}
