package com.huawei.hwmdemo.delegate;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.model.FeaturePage;
import com.huawei.hwmdemo.model.MenuGroup;

import java.util.List;

public interface IHwmUiDelegate {

    void initOpenSdkUIConfig(OpenSDKConfig sdkConfig);

    int getScreenOrientation();

    /**
     * 首页Fragment注入
     */
    @NonNull
    List<FeaturePage> getHomePages();

    /**
     * SDKListFragment功能注入，用于演示SDK基本功能
     */
    @NonNull
    List<ApiPageModel> getSdkApiFeatures();

    /**
     * MenuConfigActivity功能注入，用于演示界面菜单自定义功能
     */
    @NonNull
    List<FeaturePage> getMenuConfigPages();

    /**
     * VideoConfToolbarMenuConfigFragment功能注入，用于演示视频会议菜单注入
     */
    @NonNull
    List<MenuGroup> getVideoMeetingMenuFeatures();

    /**
     * VideoConfToolbarMenuConfigFragment名称注入
     */
    @NonNull
    String getVideoMeetingMenuHandle();

    /**
     * AudioConfToolbarMenuConfigFragment功能注入，用于演示视频会议菜单注入
     */
    @NonNull
    List<MenuGroup> getAudioMeetingMenuFeatures();

    /**
     * AudioConfToolbarMenuConfigFragment名称注入
     */
    @NonNull
    String getAudioMeetingMenuHandle();

    /**
     * WebinarConfToolbarMenuConfigFragment功能注入，用于演示视频会议菜单注入
     */
    @NonNull
    List<MenuGroup> getWebinarMeetingMenuFeatures();

    /**
     * WebinarConfToolbarMenuConfigFragment名称注入
     */
    @NonNull
    String getWebinarMeetingMenuHandle();

    /**
     * ParticipantMenuConfigFragment功能注入，用于演示视频会议菜单注入
     */
    @NonNull
    List<MenuGroup> getParticipantMenuFeatures();

    /**
     * ParticipantMenuConfigFragment名称注入
     */
    @NonNull
    String getParticipantMenuHandle();

    /**
     * AudienceMenuConfigFragment功能注入，用于演示视频会议菜单注入
     */
    @NonNull
    List<MenuGroup> getAudienceMenuFeatures();

    /**
     * AudienceMenuConfigFragment名称注入
     */
    @NonNull
    String getAudienceMenuHandle();

    /**
     * FloatingMenuConfigFragment，用于演示悬浮窗会议菜单注入
     */
    @NonNull
    List<MenuGroup> getFloatingMenuFeatures();

    /**
     * FloatingMenuConfigFragment名称注入
     */
    @NonNull
    String getFloatingMenuHandle();
}
