package com.huawei.hwmdemo.menu;

import android.content.Context;

import com.huawei.cloudlink.smartrooms.uisdk.menu.CameraMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.MicMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.ParticipantMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.SettingMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.ShareMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.SpeakerMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.SubtitlesMenu;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;

import java.util.ArrayList;
import java.util.List;

public class FloatingAttendeeToolbarMenuCreator {

    public static List<IConfMenu> createFloatingAttendeeToolbarAllMenus(Context context) {
        return createFloatingAttendeeToolbarInConfMenus(context);
    }

    public static List<IConfMenu> createFloatingAttendeeToolbarInConfMenus(Context context) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu(context));
        confMenus.add(new ShareMenu(context));
        return confMenus;
    }

    public static List<IConfMenu> createFloatingAttendeeToolbarAllMoreMenus(Context context) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new SpeakerMenu(context));
        confMenus.add(new CameraMenu(context));
        confMenus.add(new ParticipantMenu(context));
        confMenus.add(new SubtitlesMenu(context));
        confMenus.add(new SettingMenu(context));
        return confMenus;
    }

    public static List<IConfMenu> createFloatingAttendeeToolbarInConfMoreMenus(Context context, boolean isVideoConf) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new SpeakerMenu(context));
        if (isVideoConf) {
            confMenus.add(new CameraMenu(context));
        }
        confMenus.add(new ParticipantMenu(context));
        confMenus.add(new SubtitlesMenu(context));
        confMenus.add(new SettingMenu(context));
        return confMenus;
    }
}
