
package com.huawei.hwmdemo.adapter;

import android.text.Html;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.model.ConfItemModel;

import java.util.ArrayList;
import java.util.List;

public class ConfListItemAdapter extends RecyclerView.Adapter<RecyclerView.ViewHolder> {

    private static final String TAG = "ConfListItemAdapter";

    private final List<ConfItemModel> items;

    private final Listener listener;

    public ConfListItemAdapter(Listener listener) {
        items = new ArrayList<>();
        this.listener = listener;
    }

    @NonNull
    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup viewGroup, int i) {
        View itemView = LayoutInflater.from(viewGroup.getContext()).inflate(R.layout.conf_item, viewGroup, false);
        final ContentViewHolder contentViewHolder = new ContentViewHolder(itemView);
        contentViewHolder.itemView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    ConfItemModel item = items.get(contentViewHolder.getBindingAdapterPosition());
                    if (listener != null && item != null) {
                        listener.onItemClicked(item);
                    }
                } catch (Exception e) {
                    Log.e(TAG, " click item error : " + e);
                }
            }
        });
        contentViewHolder.cancelConfBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                try {
                    ConfItemModel item = items.get(contentViewHolder.getBindingAdapterPosition());
                    if (listener != null && item != null) {
                        listener.onCancelConfBtnClicked(item);
                    }
                } catch (Exception e) {
                    Log.e(TAG, " click cancel error : " + e);
                }
            }
        });
        return contentViewHolder;
    }

    @Override
    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int i) {
        ConfItemModel item = items.get(i);
        int differDays = item.getDiffDays();
        String chairManTips = String.format("chairman:%1$s", item.getScheduserName());
        ((ContentViewHolder) viewHolder).startTime.setText(item.getHMStartTime());
        ((ContentViewHolder) viewHolder).startTimeSuper.setVisibility(View.GONE);
        if (differDays != 0) {
            ((ContentViewHolder) viewHolder).endTime.setText(item.getHMEndTime());
            ((ContentViewHolder) viewHolder).endTimeSuper.setVisibility(View.VISIBLE);
            ((ContentViewHolder) viewHolder).endTimeSuper
                    .setText(Html.fromHtml("<sup>" + "+" + differDays + " </sup>"));
        } else {
            ((ContentViewHolder) viewHolder).endTimeSuper.setVisibility(View.GONE);
            ((ContentViewHolder) viewHolder).endTime.setText(item.getHMEndTime());
        }
        ((ContentViewHolder) viewHolder).itemSubText.setVisibility(item.isSubCycleConf() ? View.GONE : View.VISIBLE);

        ((ContentViewHolder) viewHolder).confChairman.setText(chairManTips);
        if (item.isCycleConf()) {
            String title = item.getConfSubject() + "（周期）";
            ((ContentViewHolder) viewHolder).confSubject.setText(title);
        } else {
            ((ContentViewHolder) viewHolder).confSubject.setText(item.getConfSubject());

        }
        ((ContentViewHolder) viewHolder).mediaType.setImageResource(item.getMediaTypeImg());
    }

    @Override
    public int getItemCount() {
        return items.size();
    }

    public void updateConfList(List<ConfItemModel> list) {
        items.clear();
        if (list != null && list.size() > 0) {
            items.addAll(list);
        }
        notifyDataSetChanged();
    }

    static class ContentViewHolder extends RecyclerView.ViewHolder {
        TextView startTime;
        TextView startTimeSuper;
        TextView endTime;
        TextView endTimeSuper;
        TextView confSubject;
        TextView confChairman;
        ImageView mediaType;
        TextView cancelConfBtn;
        LinearLayout itemSubText;

        ContentViewHolder(View itemView) {
            super(itemView);
            startTime = itemView.findViewById(R.id.demo_conf_item_start_time_text);
            startTimeSuper = itemView.findViewById(R.id.demo_conf_item_start_time_text_super);
            endTime = itemView.findViewById(R.id.demo_conf_item_end_time_text);
            endTimeSuper = itemView.findViewById(R.id.demo_conf_item_end_time_text_super);
            confSubject = itemView.findViewById(R.id.demo_conf_item_conf_subject_text);
            confChairman = itemView.findViewById(R.id.demo_conf_item_chairman_text);
            mediaType = itemView.findViewById(R.id.demo_conf_item_media_type_img);
            cancelConfBtn = itemView.findViewById(R.id.demo_conf_item_cancel_conf_btn);
            itemSubText = itemView.findViewById(R.id.demo_conf_item_sub_text);
        }
    }

    public interface Listener {
        void onItemClicked(ConfItemModel item);

        void onCancelConfBtnClicked(ConfItemModel item);
    }
}
