package com.huawei.hwmdemo.dependency;

import android.app.Activity;
import android.content.Intent;
import android.text.TextUtils;
import android.widget.Toast;

import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.cloudlink.openapi.dependency.account.IAccountEventHandle;
import com.huawei.cloudlink.openapi.model.HWMUserState;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmbiz.eventbus.AccountLockedState;
import com.huawei.hwmbiz.eventbus.AccountOrPasswordErrorState;
import com.huawei.hwmbiz.eventbus.CaInvalidState;
import com.huawei.hwmbiz.eventbus.KickOutState;
import com.huawei.hwmbiz.eventbus.LogoutResult;
import com.huawei.hwmbiz.eventbus.TokenInvalidState;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.DemoActivity;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.utils.route.HCActivityManager;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmdemo.R;

/**
 * 功能描述
 *
 */
public class CustomAccountEventHandle implements IAccountEventHandle {
    private static final String TAG = CustomAccountEventHandle.class.getSimpleName();

    @Override
    public void onAccountOrPasswordError(@Nullable AccountOrPasswordErrorState accountOrPasswordErrorState) {
        HCLog.i(TAG, "onAccountOrPasswordError");
        DemoUtil.getResContext().getString(R.string.hwmconf_token_expired);
        DemoUtil.showToast(DemoUtil.getResContext().getString(R.string.hwmconf_token_expired) + "事件：onAccountOrPasswordError");
        Activity currentActivity = HCActivityManager.getInstance().getCurActivity();
        if (null != currentActivity) {
            Intent intent = new Intent(currentActivity, DemoActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            currentActivity.startActivity(intent);
        }
    }

    @Override
    public void onTokenInvalid(@Nullable TokenInvalidState tokenInvalidState) {
        HCLog.i(TAG, "onTokenInvalid");
        if (tokenInvalidState != null) {
            if (TokenInvalidState.TOKEN_CREATE_BY_OTHER_SITE.equals(tokenInvalidState.getTokenError())) {
                DemoUtil.showToast(DemoUtil.getResContext().getString(R.string.hwmconf_server_area_change) + "事件：onTokenInvalid");
            } else {
                DemoUtil.showToast(DemoUtil.getResContext().getString(R.string.hwmconf_token_expired) + "事件：onTokenInvalid");
            }
        }
    }

    @Override
    public void onAccountLocked(@Nullable AccountLockedState accountLockedState) {
        HCLog.i(TAG, "onAccountLocked");
        DemoUtil.showToast(DemoUtil.getResContext().getString(R.string.hwmconf_login_err_account_locked) + "事件：onTokenInvalid");
    }

    @Override
    public void onKickedOut(@Nullable KickOutState kickOutState) {
        DemoUtil.showToast("你的账号在其他地方登录了");
        handleKickOut(kickOutState);
    }

    @Override
    public void onCaInvalid(@Nullable CaInvalidState caInvalidState) {
        HCLog.i(TAG, "onCaInvalid");
        DemoUtil.showToast(DemoUtil.getResContext().getString(R.string.hwmconf_certificate_verify_failed) + "事件：onCaInvalid");
    }

    private void handleKickOut(KickOutState kickOutState) {
        HCLog.i(TAG, " leaveConf ");
        if (HWMUserState.HWM_STATE_IN_CONF == HWMSdk.getOpenApi(HWMBizSdk.getApplication()).getHWMUserState()) {
            HWMSdk.getOpenApi(HWMBizSdk.getApplication()).leaveConf(new HwmCallback<Integer>() {
                @Override
                public void onSuccess(Integer integer) {
                    Toast.makeText(HWMBizSdk.getApplication(), "已成功离开会议", Toast.LENGTH_SHORT)
                        .show();
                }

                @Override
                public void onFailed(int retCode, String desc) {
                    HCLog.i(TAG,"leaveConf onFailed" + retCode + " " + desc);
                    String err = ErrorMessageFactory.create(retCode);
                    if (!TextUtils.isEmpty(err)) {
                        desc = err;
                    }
                    DemoUtil.showToastDialog("leaveConf", retCode, desc);
                }
            });
            //注销
            dealLogout(kickOutState);
        } else {
            //注销
            dealLogout(kickOutState);
        }
    }

    private void dealLogout(KickOutState kickOutState) {
        HWMSdk.getOpenApi(HWMBizSdk.getApplication()).logout(new HwmCallback<LogoutResult>() {
            @Override
            public void onSuccess(LogoutResult result) {
                if (result == null) {
                    DemoUtil.showToast("登出成功但未获取到回调信息");
                    return;
                }
                DemoUtil.showToast("登出成功:" + result.getUserUuid() + "; account：" + result.getAccount()
                    + "; thirdAccount：" + result.getThirdAccount());
                doAfterKickOut();
            }

            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.i(TAG,"logout onFailed" + retCode + " " + desc);
                doAfterKickOut();
            }
        });
    }

    private void doAfterKickOut() {
        Activity currentActivity = HCActivityManager.getInstance().getCurActivity();
        if (null != currentActivity) {
            Intent intent = new Intent(currentActivity, DemoActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
            currentActivity.startActivity(intent);
        }
    }
}
