package com.huawei.hwmdemo.dependency;

import android.app.Activity;
import android.content.Intent;

import com.huawei.hwmconf.presentation.dependency.IAddAttendeesHandle;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.sdkconfig.AddPeopleActivity;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmsdk.enums.SDKERR;

import java.util.List;

/**
 * 点击添加与会者界面注入，在方法中跳转到自己的选人界面
 * 调用的activity
 * 已选择的账号
 * 基线跳转页面参数，外部调用时传空即可
 * 是否预约会议
 * 加人完成后返回已选中与会者列表
 */
public class CustomAddAttendeesHandle implements IAddAttendeesHandle {
    private HwmCallback<List<AttendeeModel>> callback;

    @Override
    public void doAddAttendees(Activity activity, List<AttendeeModel> list, String s, boolean b,
        HwmCallback<List<AttendeeModel>> hwmCallback) {
        callback = hwmCallback;
        DemoUtil.clearSelectModels();
        Intent intent = new Intent(DemoUtil.getApplication(), AddPeopleActivity.class);
        //可以传入已经选择的与会者列表在自定义界面做操作
        DemoUtil.attendeeModels = list;
        activity.startActivityForResult(intent, 5000);
    }

    @Override
    public void dealContactSelect(Intent intent) {

    }

    @Override
    public void onActivityResult(int i, int i1, Intent intent) {
        if (i == 5000) {
            if (null != callback) {
                if (DemoUtil.selectModels == null || DemoUtil.selectModels.size() == 0) {
                    callback.onFailed(SDKERR.SDKERR_UNKOWN.getValue(), "fail to select attendee");
                } else {
                    callback.onSuccess(DemoUtil.selectModels);
                }
            }
        }
    }
}
