package com.huawei.hwmdemo.dependency;

import android.app.Application;

import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.PreferencesUtil;
import com.huawei.hwmfoundation.depency.ILoggerHandle;
import com.huawei.hwmfoundation.utils.FileUtil;

import java.io.File;

public class CustomLoggerHandle implements ILoggerHandle {

    private Application application;
    public CustomLoggerHandle(Application application) {
        this.application = application;
    }

    @Override
    public String getLogPath() {
        String customLogPath = PreferencesUtil.getStringPreference(application, ConfigConstant.KEY_LOG_PATH, "custom-log");
        return FileUtil.getExternalFilesDir(this.application) + File.separator + customLogPath + File.separator;
    }

}
