package com.huawei.hwmdemo.dependency;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;

/**
 * 功能描述
 *
 */
public class SdkHelper {

    private static volatile SdkHelper instance;

    private MeetingInfoChangeListener meetingInfoChangeListener;

    private ConfInfo confInfoCache;

    public static SdkHelper getInstance() {
        SdkHelper helper = instance;
        if (helper == null) {
            synchronized (SdkHelper.class) {
                helper = instance;
                if (helper == null) {
                    instance = helper = new SdkHelper();
                }
            }
        }
        return helper;
    }

    public boolean isHost() {
        return HWMBizSdk.getBizOpenApi().isSelfChairMan();
    }

    public void setConfInfoCache(ConfInfo confInfo) {
        confInfoCache = confInfo;
        if (meetingInfoChangeListener != null) {
            meetingInfoChangeListener.onConfDetailNotify(confInfoCache);
        }
    }

    public void clearConfInfoCache() {
        setConfInfoCache(new ConfInfo());
    }

    public ConfInfo getConfInfoCache() {
        return confInfoCache;
    }

    public void setMeetingInfoChangeListener(MeetingInfoChangeListener listener) {
        meetingInfoChangeListener = listener;
    }

}
