package com.huawei.hwmdemo.dependency.menu.participant;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.CameraMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.AllowUnmuteOrNotMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.GrantOrCancelLocalRecordMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.HandsUpOrDownMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SharingBroadcastAndCancelMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.more.LockOrUnlockConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.ReleaseOrRequestChairManMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.AdmitMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.AutoAdmitMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.BroastAndCacelMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.CallOtherNumberMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.HangupMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.InviteOrCancelShareMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.MoveToWaitingRoomMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.MuteOrUnmuteMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.PrivateChatMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RecallMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RemoveMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RenameMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SelectWatchOrCacnelMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SetAttendeeMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SetChairmanMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.SetOrCancelCoHostMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.more.ContantMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.more.ParticipantShareMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.AdmitAllMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.CallAllMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.CancelAllMuteMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.HandsDownMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.HandsupMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.MoreMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.MuteAllMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.RemoveAllMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.toolbar.RequestChairmanMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IParticipantMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMenu;
import com.huawei.hwmdemo.dependency.menu.item.CustomMoreMenu;

import java.util.ArrayList;
import java.util.List;

public class CustomParticipantMenuHandle implements IParticipantMenuStrategy {

    @Override
    public List<IConfMenu> buildParticipantMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new ParticipantShareMenu());
        confMenus.add(new ContantMenu());
        //【演示】增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantItemMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        // 分组1
        confMenus.add(new MuteOrUnmuteMenu());//静音
        confMenus.add(new CameraMenu());//视频
        confMenus.add(new HandsUpOrDownMenu().setDarkIcon(true));//举手
        confMenus.add(new SelectWatchOrCacnelMenu());//选看
        confMenus.add(new PrivateChatMenu());// 私聊
        confMenus.add(new SharingBroadcastAndCancelMenu());//广播共享
        confMenus.add(new BroastAndCacelMenu());//广播视频
        // 分组2
        confMenus.add(new RenameMenu());//改名
        confMenus.add(new InviteOrCancelShareMenu());//邀请共享或取消共享
        confMenus.add(new GrantOrCancelLocalRecordMenu());//允许或禁止本地录制
        confMenus.add(new SetAttendeeMenu());//设为观众
        confMenus.add(new ReleaseOrRequestChairManMenu());//申请/释放主持人
        confMenus.add(new SetChairmanMenu());//设为主持人
        confMenus.add(new SetOrCancelCoHostMenu());//设为/撤销联席主持人
        confMenus.add(new MoveToWaitingRoomMenu()); // 移至等候室
        confMenus.add(new RecallMenu());//重新呼叫
        if (HWMBizSdk.getPublicConfigApi().isChinaSite()) {
            confMenus.add(new CallOtherNumberMenu());//呼叫其他号码
        }
        // 分组3
        confMenus.add(new HangupMenu());//挂断
        confMenus.add(new AdmitMenu());//准入
        confMenus.add(new AutoAdmitMenu());//自动准入
        confMenus.add(new RemoveMenu());//移除

        //【演示】增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();

        //--------------主席身份下才有的菜单-------------
        //全场静音
        confMenus.add(new MuteAllMenu());
        //取消全场静音
        confMenus.add(new CancelAllMuteMenu());
        //更多
        confMenus.add(new MoreMenu());

        //--------------非主席身份下才有的菜单-------------
        //举手
        confMenus.add(new HandsupMenu());
        //手放下
        confMenus.add(new HandsDownMenu());
        //申请主持人
        confMenus.add(new RequestChairmanMenu());

        //-----------演示增加自定义菜单----------
        confMenus.add(new CustomMenu());

        return confMenus;
    }

    @Override
    public List<IConfMenu> buildWaitingToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new AdmitAllMenu());
        confMenus.add(new RemoveAllMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildUnJoinedToolbarMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new CallAllMenu());
        confMenus.add(new CustomMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new ReleaseOrRequestChairManMenu());
        confMenus.add(new AllowUnmuteOrNotMenu());
        confMenus.add(new LockOrUnlockConfMenu());
        //【演示】增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }

}
