package com.huawei.hwmdemo.dependency.menu.statusbar.wrapper;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IStatusBarMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.statusbar.CustomStatusBarMenuHandle;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public class CustomStatusBarMenuHandleWrapper implements IStatusBarMenuStrategy {
    protected IStatusBarMenuStrategy handle;

    public CustomStatusBarMenuHandleWrapper() {
        handle = new CustomStatusBarMenuHandle();
    }

    @Override
    public List<IConfMenu> buildRecordMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildRecordMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }
}
