package com.huawei.hwmdemo.dependency.menu.toolbar.handle;

import com.huawei.cloudlink.tup.TupConfig;
import com.huawei.hwmbiz.util.CpuLevelUtil;
import com.huawei.hwmconf.presentation.ConfUIConfig;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.AudienceJoinMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.CameraMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.HandsMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.MicMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.MoreMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.ParticipantMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.ShareConfLinkMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.ShareMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.VoteBtnMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.ChatMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.CloudLiveMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.ConfSettingMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.ConnectAudioMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.DisconnectAudioMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.HandsUpOrDownMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.InviteMoreMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.OpenOrCloseRecordMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.StartOrStopShareMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.SubtitlesMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.SwitchCameraMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.VirtualBackgroundMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.more.VoteMenu;
import com.huawei.hwmconf.presentation.dependency.menu.buildin.participant.item.RenameMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.type.MenuContainer;
import com.huawei.hwmconf.presentation.dependency.menu.v2.type.RouterMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.type.SwitchMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.type.TextMenu;
import com.huawei.hwmdemo.dependency.menu.item.CustomMenu;
import com.huawei.hwmsdk.NativeSDK;
import com.huawei.hwmsdk.enums.ConfRole;
import com.huawei.hwmsdk.enums.CpuLevel;
import com.huawei.hwmdemo.R;

import java.util.ArrayList;
import java.util.List;

public class CustomConfWebinarToolbarHandle implements IToolbarMenuStrategy {

    @Override
    public List<IConfMenu> buildMenuItems() {

        if (!NativeSDK.getConfMgrApi().isInConf()) {
            return buildAllMenuItems();
        }

        if (NativeSDK.getConfStateApi().getSelfRole() == ConfRole.ROLE_AUDIENCE) {
            return buildAudienceMenuItems();
        }

        if (NativeSDK.getConfStateApi().getSelfRole() == ConfRole.ROLE_HOST) {
            return buildHostMenuItems();
        }

        return buildAttendeeMenuItems();
    }

    private List<IConfMenu> buildAllMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu());
        confMenus.add(new CameraMenu());
        if (TupConfig.isNeedConfChat()) {
            confMenus.add(new ChatMenu());
        }
        confMenus.add(new HandsMenu());
        if (TupConfig.isNeedScreenShare() && CpuLevelUtil.isHigherThan(CpuLevel.CALL_CPU_LEVEL_SUPER_LOW)) {
            confMenus.add(new ShareMenu());
        }
        if (ConfUIConfig.getInstance().isAudience()) {
            confMenus.add(new VoteBtnMenu());
        }
        confMenus.add(new AudienceJoinMenu());
        confMenus.add(new ParticipantMenu());
        confMenus.add(new MoreMenu());
        return confMenus;
    }

    private List<IConfMenu> buildAudienceMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu());
        if (TupConfig.isNeedConfChat()) {
            confMenus.add(new ChatMenu());
        }
        confMenus.add(new HandsMenu());
        if (ConfUIConfig.getInstance().isAudience()) {
            confMenus.add(new VoteBtnMenu());
        }
        confMenus.add(new MoreMenu());
        return confMenus;
    }

    private List<IConfMenu> buildAttendeeMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu());
        confMenus.add(new CameraMenu());
        if (TupConfig.isNeedScreenShare() && CpuLevelUtil.isHigherThan(CpuLevel.CALL_CPU_LEVEL_SUPER_LOW)) {
            confMenus.add(new ShareMenu());
        }
        confMenus.add(new ParticipantMenu());
        if (ConfUIConfig.getInstance().isAudience()) {
            confMenus.add(new VoteBtnMenu());
        }
        confMenus.add(new MoreMenu());
        return confMenus;
    }

    private List<IConfMenu> buildHostMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new MicMenu());
        confMenus.add(new CameraMenu());
        confMenus.add(new AudienceJoinMenu());
        confMenus.add(new ParticipantMenu());
        confMenus.add(new MoreMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new ConnectAudioMenu());
        confMenus.add(new DisconnectAudioMenu());
        confMenus.add(new RenameMenu());
        confMenus.add(new StartOrStopShareMenu());
        confMenus.add(new ChatMenu());
        confMenus.add(new ShareConfLinkMenu());
        confMenus.add(new HandsUpOrDownMenu());
        confMenus.add(new InviteMoreMenu());
        confMenus.add(new OpenOrCloseRecordMenu());
        confMenus.add(new SubtitlesMenu());
        confMenus.add(new CloudLiveMenu());
        confMenus.add(new SwitchCameraMenu());
        confMenus.add(new VirtualBackgroundMenu());
        confMenus.add(new VoteMenu());
        confMenus.add(new ConfSettingMenu());
        //【演示】增加一个自定义菜单
        confMenus.add(new CustomMenu());
        return confMenus;
    }


    @Override
    public List<IConfMenu> buildSettingMenuItems() {

        List<IConfMenu> menus = new ArrayList<>();

        List<IConfMenu> audioVideomenuChildren = new ArrayList<>();
        IConfMenu howlDetectMenu = new SwitchMenu(R.id.hwmconf_confsetting_whistle_detection, com.huawei.hwmdemo.R.string.hwmconf_mine_calling_setting_howl_auto_mute, true);
        IConfMenu beautyMenu = new SwitchMenu(R.id.hwmconf_confsetting_beauty, com.huawei.hwmdemo.R.string.hwmconf_setting_beauty, true);
        IConfMenu mirrorMenu = new SwitchMenu(R.id.hwmconf_confsetting_video_mirror, R.string.hwmconf_video_mirroring, true);
        IConfMenu pipMenu = new SwitchMenu(R.id.hwmconf_confsetting_hide_self, com.huawei.hwmdemo.R.string.hwmconf_setting_pip, true);
        IConfMenu directionMenu = new RouterMenu(R.id.hwmconf_confsetting_camera_direction,
                R.string.hwmconf_auto, "cloudlink://hwmeeting/cameradirection");
        IConfMenu noiseReductionMenu = new SwitchMenu(R.id.hwmconf_confsetting_noise_reduction,
                R.string.hwmconf_audio_noise_reduction, true);
        IConfMenu highResMenu = new SwitchMenu(R.id.hwmconf_confsetting_high_resolution,
                R.string.hwmconf_mine_calling_setting_high_resolution, true);
        IConfMenu enableBrightenMenu = new SwitchMenu(R.id.hwmconf_confsetting_enable_brighten,
                R.string.hwmconf_enhance_video_quality, false);
        IConfMenu pictureRatioMenu = new TextMenu(R.id.hwmconf_confsetting_picture_ratio,
                R.string.hwmconf_picture_ratio, R.string.hwmconf_picture_ratio_original_size);
        audioVideomenuChildren.add(howlDetectMenu);
        audioVideomenuChildren.add(beautyMenu);
        audioVideomenuChildren.add(mirrorMenu);
        audioVideomenuChildren.add(pipMenu);
        audioVideomenuChildren.add(directionMenu);
        audioVideomenuChildren.add(noiseReductionMenu);
        audioVideomenuChildren.add(highResMenu);
        audioVideomenuChildren.add(enableBrightenMenu);
        audioVideomenuChildren.add(pictureRatioMenu);
        MenuContainer audioVideoMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_audio_video, com.huawei.hwmdemo.R.string.hwmconf_setting_audio_video, audioVideomenuChildren);

        List<IConfMenu> securityMenuChildren = new ArrayList<>();
        //锁定会议
        IConfMenu lockConfMenu = new SwitchMenu(R.id.hwmconf_confsetting_lock_meeting, com.huawei.hwmdemo.R.string.hwmconf_lock, false);
        securityMenuChildren.add(lockConfMenu);
        //允许入会
        IConfMenu allowJoinConfMenu = new TextMenu(R.id.hwmconf_confsetting_allow_join_conf,
                R.string.hwmconf_allow_incoming_call, R.string.hwmconf_everyone);
        securityMenuChildren.add(allowJoinConfMenu);
        // 开启等候室
        IConfMenu enableWaitingRoomMenu = new SwitchMenu(R.id.hwmconf_confsetting_enable_waiting_room,
                R.string.hwmconf_enable_waiting_room, false);
        securityMenuChildren.add(enableWaitingRoomMenu);
        // 入会自动静音
        IConfMenu autoMuteRoomMenu = new RouterMenu(R.id.hwmconf_confsetting_auto_mute_item, R.string.hwmconf_join_conf_auto_mute, "");
        securityMenuChildren.add(autoMuteRoomMenu);

        MenuContainer securityMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_security, com.huawei.hwmdemo.R.string.hwmconf_setting_safe, securityMenuChildren);

        List<IConfMenu> sharePermissionMenuChildren = new ArrayList<>();
        // 同时共享设置
        IConfMenu multiShareMenu = new TextMenu(R.id.hwmconf_confsetting_multi_sharing,
                R.string.hwmconf_setting_share_at_same_time, R.string.hwmconf_only_one_can_share_at_a_time);
        // 共享设置
        IConfMenu allowShareMuteMenu = new TextMenu(R.id.hwmconf_confsetting_allow_sharing,
                R.string.hwmconf_share_setting, R.string.hwmconf_only_host_can_share);
        // 抢占共享权限
        IConfMenu preemptShareTypeMenu = new TextMenu(R.id.hwmconf_confsetting_preempt_share_type,
                R.string.hwmconf_preempt_share_permission, R.string.hwmconf_preempt_share_only_host);
        sharePermissionMenuChildren.add(multiShareMenu);
        sharePermissionMenuChildren.add(allowShareMuteMenu);
        sharePermissionMenuChildren.add(preemptShareTypeMenu);
        MenuContainer sharePermissionMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_share_permission,
                R.string.hwmconf_setting_share_permission, sharePermissionMenuChildren);

        List<IConfMenu> attendeePermissionMenuChildren = new ArrayList<>();
        //允许解除静音
        IConfMenu allowReleaseMuteMenu = new SwitchMenu(R.id.hwmconf_confsetting_allow_unmute, com.huawei.hwmdemo.R.string.hwmconf_allow_ummute_self, false);
        //允许开启视频
        IConfMenu cameraRestrictionSwitch = new SwitchMenu(R.id.hwmconf_confsetting_allow_open_camera, R.string.hwmconf_allow_open_video, false);
        IConfMenu cameraRestrictionMenu = new RouterMenu(R.id.hwmconf_confsetting_camera_restriction, R.string.hwmconf_camera_restriction, "");
        //聊天权限设置
        IConfMenu chatPermissionMenu = new TextMenu(R.id.hwmconf_confsetting_chat_permission,
                R.string.hwmconf_chat_settings, R.string.hwmconf_private_chat_free);//允许改名
        //允许改名
        IConfMenu allowRenameMenu = new SwitchMenu(R.id.hwmconf_confsetting_allow_rename, com.huawei.hwmdemo.R.string.hwmconf_set_allow_rename, true);
        IConfMenu allowLocalRecordMenu = new RouterMenu(R.id.hwmconf_confsetting_local_record_permission,
            R.string.hwmconf_allow_record, "");
        attendeePermissionMenuChildren.add(allowReleaseMuteMenu);
        attendeePermissionMenuChildren.add(cameraRestrictionSwitch);
        attendeePermissionMenuChildren.add(cameraRestrictionMenu);
        attendeePermissionMenuChildren.add(chatPermissionMenu);
        attendeePermissionMenuChildren.add(allowRenameMenu);
        attendeePermissionMenuChildren.add(allowLocalRecordMenu);
        /*
         * 【演示】在会议设置里新增一个设置项
         */
        IConfMenu customeSettingMenuTest1 = new SwitchMenu(com.huawei.hwmdemo.R.id.conf_setting_menu_test1, com.huawei.hwmdemo.R.string.menu_conf_setting_menu_test1, false);
        attendeePermissionMenuChildren.add(customeSettingMenuTest1);
        MenuContainer attendeePermissionMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_paticipant_permission, com.huawei.hwmdemo.R.string.hwmconf_setting_participant_permission, attendeePermissionMenuChildren);


        List<IConfMenu> commonMenuChildren = new ArrayList<>();
        // 字幕设置 : 字幕翻译语言 + 我正在说
        IConfMenu subtitleSettingMenu = new RouterMenu(R.id.hwmconf_subtitle_setting, R.string.hwmconf_subtitle_setting,
                "cloudlink://hwmeeting/subtitlesetting");
        commonMenuChildren.add(subtitleSettingMenu);
        // 字幕翻译语言(已废弃，建议使用字幕设置：hwmconf_subtitle_setting)
        IConfMenu subtitlesLanguageMenu = new TextMenu(R.id.hwmconf_confsetting_subtitles_language, R.string.hwmconf_subtitle_translation_language, R.string.hwmconf_auto_no_translation);
        commonMenuChildren.add(subtitlesLanguageMenu);
        // 聊天消息提醒
        IConfMenu chatMessageRemindMenu = new TextMenu(R.id.hwmconf_confsetting_chat_message_remind,
                R.string.hwmconf_message_notify_mode, R.string.hwmconf_bubble_message_mode);
        commonMenuChildren.add(chatMessageRemindMenu);
        //网络检测
        IConfMenu networkDetectMenu = new RouterMenu(R.id.hwmconf_confsetting_network_detect, com.huawei.hwmdemo.R.string.hwmconf_network_check, "cloudlink://hwmeeting/networkdetection");
        commonMenuChildren.add(networkDetectMenu);
        MenuContainer commonMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_common, com.huawei.hwmdemo.R.string.hwmconf_setting_common, commonMenuChildren);

        // 会中信息安全设置-防截屏和会议水印
        List<IConfMenu> informationSecurityMenuChildren = new ArrayList<>();
        IConfMenu forbiddenScreenShotsMenu = new SwitchMenu(R.id.hwmconf_confsetting_forbiddenscreenshots, R.string.hwmconf_forbidden_screen_shots, false);
        informationSecurityMenuChildren.add(forbiddenScreenShotsMenu);
        IConfMenu waterMarkMenu = new SwitchMenu(R.id.hwmconf_confsetting_watermark, R.string.hwmconf_conf_watermark, false);
        informationSecurityMenuChildren.add(waterMarkMenu);

        MenuContainer informationSecurityMenuContainer = new MenuContainer(R.id.hwmconf_setting_menu_information_security,
                R.string.hwmconf_information_security, informationSecurityMenuChildren);

        menus.add(audioVideoMenuContainer);
        menus.add(securityMenuContainer);
        menus.add(informationSecurityMenuContainer);
        menus.add(sharePermissionMenuContainer);
        menus.add(attendeePermissionMenuContainer);
        menus.add(commonMenuContainer);

        /*
         * 【演示】在会议设置里新增加一个设置项组
         */
        List<IConfMenu> customChildren = new ArrayList<>();
        //网络检测
        IConfMenu customeSettingMenuTest2 = new RouterMenu(com.huawei.hwmdemo.R.id.conf_setting_menu_test2, com.huawei.hwmdemo.R.string.menu_conf_setting_menu_test1, "test");
        customChildren.add(customeSettingMenuTest2);
        MenuContainer customContainer = new MenuContainer(com.huawei.hwmdemo.R.id.conf_setting_menu_test_group, com.huawei.hwmdemo.R.string.menu_conf_setting_menu_test_group, customChildren);
        menus.add(customContainer);

        return menus;
    }
}
