package com.huawei.hwmdemo.dependency.menu.toolbar.wrapper;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public class CustomConfToolbarStrategyWrapper implements IToolbarMenuStrategy {

    protected IToolbarMenuStrategy handle;

    protected CustomConfToolbarStrategyWrapper() {
    }

    @Override
    public List<IConfMenu> buildMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildMoreMenuItems() {
        List<IConfMenu> confMenus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildMoreMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildMoreMenuItems", confMenu)) {
                confMenus.add(confMenu);
            }
        }
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildSettingMenuItems() {
        List<IConfMenu> menus = new ArrayList<>();
        List<IConfMenu> originMenus = handle.buildSettingMenuItems();
        for (IConfMenu confMenu : originMenus) {
            if (!DemoUtil.disabled(handle.getClass().getName(), "buildSettingMenuItems", confMenu)) {
                menus.add(confMenu);
            }
        }
        return menus;
    }
}
