package com.huawei.hwmdemo.view.base;

import android.os.Bundle;

import androidx.fragment.app.DialogFragment;

import com.huawei.hwmdemo.view.BaseActivity;

public class BaseDialogFragment extends DialogFragment {
    private boolean mStateEnable;

    public void showLoading() {
        if (getActivity() != null) {
            ((BaseActivity)getActivity()).showLoading();
        }
    }

    public void dismissLoading() {
        if (getActivity() != null) {
            ((BaseActivity)getActivity()).dismissLoading();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        mStateEnable = true;
        // 如果因为页面跳转dialog没有消失，这里重新dismiss一次
        dismissLoading();
    }

    @Override
    public void onStart() {
        mStateEnable = true;
        super.onStart();
        dismissLoading();
    }


    @Override
    public void onSaveInstanceState(Bundle outState) {
        mStateEnable = false;
        super.onSaveInstanceState(outState);
    }

    @Override
    public void onStop() {
        mStateEnable = false;
        super.onStop();
    }

    protected void doDismissDialogAndFragment() {
        dismissLoading();
        if (mStateEnable) {
            dismissLoading();
            dismiss();
        }
    }
}
