package com.huawei.hwmdemo.view.base;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.adapter.MyRecyclerViewAdapter;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.List;

public class BaseListFragment extends Fragment {
    public RecyclerView mRecyclerView;
    public MyRecyclerViewAdapter mAdapter;
    public TextView mText;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.main_list, container, false);
        mRecyclerView = view.findViewById(R.id.main_list);
        mText = view.findViewById(R.id.main_text);
        mRecyclerView.setLayoutManager(new LinearLayoutManager(getContext()));
        mAdapter = new MyRecyclerViewAdapter(getItems());
        mRecyclerView.setAdapter(mAdapter);
        //设置分割线
        mRecyclerView.addItemDecoration(DemoUtil.getRecyclerViewDivider(getContext(), R.drawable.main_recycler_decoration));
        mAdapter.setOnItemClickListener(new MyRecyclerViewAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(View view, int position, ApiPageModel data) {
                handleItemClick(position, data);
            }

            @Override
            public void onItemLongClick(View view, int position, ApiPageModel data) {
                handleItemLongClick(position, data);
            }
        });
        return view;
    }

    public void handleItemClick(int position, ApiPageModel data) {

    }

    public void handleItemLongClick(int position, ApiPageModel data) {

    }

    public List<ApiPageModel> getItems() {
        return null;
    }

}
