package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.callback.HwmCallback;

public class ActivateFragment extends BaseDialogFragment {
    public final static String TAG = ActivateFragment.class.getSimpleName();

    private EditText etActivateCode;

    private TextView tvErrorMessage;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.sdk_activate, container, false);
        ((TextView) vRoot.findViewById(R.id.tv_current_site))
                .setText("当前站点 " + ((TextUtils.isEmpty(DemoUtil.getCustomSiteAddress())) ? ((DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)
                        ? "国际站"
                        : "国内站"))
                        : (DemoUtil.getCustomSiteAddress() + ":" + DemoUtil.getCustomSitePort())));
        if (isActivated()) {
            vRoot.findViewById(R.id.ll_activate_container).setVisibility(View.GONE);
            vRoot.findViewById(R.id.ll_deactivate_container).setVisibility(View.VISIBLE);
            vRoot.findViewById(R.id.btn_deactivate).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    handleDeactivateClicked();
                }
            });
        } else {
            vRoot.findViewById(R.id.ll_activate_container).setVisibility(View.VISIBLE);
            vRoot.findViewById(R.id.ll_deactivate_container).setVisibility(View.GONE);
            etActivateCode = vRoot.findViewById(R.id.et_activate_code);
            vRoot.findViewById(R.id.btn_activate).setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    handleActivateClicked();
                }
            });
        }
        tvErrorMessage = vRoot.findViewById(R.id.tv_error_message);
        return vRoot;
    }

    private static boolean isActivated() {
        return HWMSdk.getOpenApi(DemoUtil.getApplication()).isActivated();
    }

    private void handleDeactivateClicked() {
        tvErrorMessage.setText("");
        showLoading();
        HWMSdk.getOpenApi(DemoUtil.getApplication()).deactivate(new HwmCallback<Void>() {
            @Override
            public void onFailed(int retCode, String desc) {
                dismissLoading();
                DemoUtil.showToast("解除激活失败");
                tvErrorMessage.setText("解除激活失败 retCode:" + retCode + ",desc:" + desc);
            }

            @Override
            public void onSuccess(Void unused) {
                DemoUtil.showToast("解除激活成功");
                dismiss();
                new Handler(Looper.getMainLooper()).postDelayed(new Runnable() {
                    @Override
                    public void run() {
                        dismissLoading();
                        DemoUtil.restartApplication();
                    }
                }, 1500L);
            }
        });
    }

    private void handleActivateClicked() {
        tvErrorMessage.setText("");
        String activateCode = etActivateCode.getText().toString().trim();
        if (TextUtils.isEmpty(activateCode)) {
            DemoUtil.showToast("激活码为空");
            tvErrorMessage.setText("激活码为空");
            return;
        }
        showLoading();
        HWMSdk.getOpenApi(DemoUtil.getApplication()).activeByCode(activateCode, new HwmCallback<Void>() {
            @Override
            public void onFailed(int retCode, String desc) {
                dismissLoading();
                DemoUtil.showToast("激活失败");
                tvErrorMessage.setText("激活失败 retCode:" + retCode + ",desc:" + desc);
            }

            @Override
            public void onSuccess(Void unused) {
                dismissLoading();
                DemoUtil.showToast("激活成功");
                dismiss();
            }
        });
    }
}
