package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Switch;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.enums.DeployType;
import com.huawei.hwmsdk.model.result.DeployInfo;
import com.huawei.hwmsdk.model.result.ServerInfo;

public class DeployInfoConfigPFragment extends BaseDialogFragment {
    private EditText serverAddress;
    private EditText serverPort;
    private Switch sinkMode;
    private Button button;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.sdk_deploy_info_config, container, false);
        serverAddress = rootView.findViewById(R.id.server_address_input);
        serverPort = rootView.findViewById(R.id.server_port_input);
        sinkMode = rootView.findViewById(R.id.switch_to_sink_mode_conf);
        button = rootView.findViewById(R.id.set_deploy_info_btn);
        button.setOnClickListener(this::setDeployInfo);
        return rootView;
    }

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        serverAddress.setText(DemoUtil.getDeployInfoSiteAddress());
        String port = String.valueOf(DemoUtil.getDeployInfoSitePort());
        serverPort.setText(TextUtils.equals(port, "0") ? ConfigConstant.COMMON_SERVER_PORT : port);
        sinkMode.setChecked(DemoUtil.getDeployType() == DeployType.SINK_MODE);
    }

    private void setDeployInfo(View view) {
        if (TextUtils.isEmpty(serverAddress.getText()) || TextUtils.isEmpty(serverPort.getText())) {
            DemoUtil.showToast("请输入有效地址");
            return;
        }
        DemoUtil.setDeployInfoSiteAddress(serverAddress.getText().toString().trim());
        DemoUtil.setDeployInfoSitePort(Integer.parseInt(serverPort.getText().toString().trim()));
        DemoUtil.setDeployType(sinkMode.isChecked() ? DeployType.SINK_MODE : DeployType.CLOUD_MODE);

        DeployInfo deployInfo = new DeployInfo();
        ServerInfo serverInfo = new ServerInfo();
        serverInfo.setServerAddr(serverAddress.getText().toString());
        serverInfo.setServerPort(Integer.parseInt(serverPort.getText().toString().trim()));
        deployInfo.setServerInfo(serverInfo);
        deployInfo.setDeployType(sinkMode.isChecked() ? DeployType.SINK_MODE : DeployType.CLOUD_MODE);
        HWMBizSdk.getBizOpenApi().setDeployInfo(deployInfo);
        doDismissDialogAndFragment();
    }
}
