package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.RadioButton;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmsdk.enums.VideoWndDisplayMode;

public class DisplayModeConfigFragment extends BaseDialogFragment {
    public final static String TAG = DisplayModeConfigFragment.class.getSimpleName();
    private View rootView;
    private RadioGroup localGroup;
    private RadioGroup remoteGroup;
    private int localMode;
    private int remoteMode;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_display_mode, container, false);
        initLocal();
        initRemote();
        return rootView;
    }

    private void initLocal() {
        localGroup = rootView.findViewById(R.id.local_group);
        localMode = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_LOCAL_DISPLAY_MODE,
            VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue(), DemoUtil.getApplication());
        if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_BLACK_BORDER.getValue() == localMode) {
            ((RadioButton)rootView.findViewById(R.id.local_mode_border)).setChecked(true);
        } else if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue() == localMode) {
            ((RadioButton)rootView.findViewById(R.id.local_mode_clipping)).setChecked(true);
        } else if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_ZOOM.getValue() == localMode) {
            ((RadioButton)rootView.findViewById(R.id.local_mode_none)).setChecked(true);
        } else {
            ((RadioButton)rootView.findViewById(R.id.local_mode_adaptive)).setChecked(true);
        }

        localGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.local_mode_border) {
                    localMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_BLACK_BORDER.getValue();
                } else if (id == R.id.local_mode_clipping) {
                    localMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue();
                } else if (id == R.id.local_mode_none) {
                    localMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_ZOOM.getValue();
                } else {
                    localMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_AUTO_ADAPT.getValue();
                }
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_LOCAL_DISPLAY_MODE,
                    localMode, DemoUtil.getApplication());
            }
        });

    }

    private void initRemote() {
        remoteGroup = rootView.findViewById(R.id.remote_group);
        remoteMode = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_REMOTE_DISPLAY_MODE,
            VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue(), DemoUtil.getApplication());
        if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_BLACK_BORDER.getValue() == remoteMode) {
            ((RadioButton)rootView.findViewById(R.id.remote_mode_border)).setChecked(true);
        } else if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue() == remoteMode) {
            ((RadioButton)rootView.findViewById(R.id.remote_mode_clipping)).setChecked(true);
        } else if (VideoWndDisplayMode.VIDEO_WND_DISPLAY_ZOOM.getValue() == remoteMode) {
            ((RadioButton)rootView.findViewById(R.id.remote_mode_none)).setChecked(true);
        } else {
            ((RadioButton)rootView.findViewById(R.id.remote_mode_adaptive)).setChecked(true);
        }

        remoteGroup.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int id) {
                if (id == R.id.remote_mode_border) {
                    remoteMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_BLACK_BORDER.getValue();
                } else if (id == R.id.remote_mode_clipping) {
                    remoteMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_CROP.getValue();
                } else if (id == R.id.remote_mode_none) {
                    remoteMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_ZOOM.getValue();
                } else {
                    remoteMode = VideoWndDisplayMode.VIDEO_WND_DISPLAY_AUTO_ADAPT.getValue();
                }
                PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_REMOTE_DISPLAY_MODE,
                    remoteMode, DemoUtil.getApplication());
            }
        });
    }

}
