package com.huawei.hwmdemo.view.sdk;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoListModel;
import com.huawei.hwmconf.sdk.model.conf.entity.VmrInfoModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.adapter.VmrListItemAdapter;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmdemo.view.sdkconfig.VmrConfDetailActivity;
import com.huawei.hwmfoundation.HwmContext;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmfoundation.utils.route.HCActivityManager;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.enums.ConfAllowJoinUserType;
import com.huawei.hwmsdk.model.param.ModifyVmrParam;

import java.util.List;

public class ListVmrIdFragment extends BaseDialogFragment implements VmrListItemAdapter.Listener {

    public final static String TAG = ListVmrIdFragment.class.getSimpleName();

    private VmrListItemAdapter adapter;

    private View vRoot;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        vRoot = inflater.inflate(R.layout.sdk_vmr_list, container, false);
        initVmrConfList();
        vRoot.postDelayed(() -> {
            if (isDetached()) {
                HCLog.i(TAG, " isDetached ");
                return;
            }
            HWMBizSdk.getBizOpenApi().getVmrInfoList(new HwmCallback<VmrInfoListModel>() {
                @Override
                public void onSuccess(VmrInfoListModel vmrInfoListModel) {
                    if (vmrInfoListModel == null || vmrInfoListModel.getVmrInfoList() == null) {
                        HCLog.e(TAG, " getVmrInfoList vmrInfoListModel is invalid ");
                        updateVmrList(null);
                        return;
                    }
                    HCLog.i(TAG, " getVmrInfoList size : " + vmrInfoListModel.getVmrInfoList().size());
                    updateVmrList(vmrInfoListModel.getVmrInfoList());
                }

                @Override
                public void onFailed(int retCode, String desc) {
                    HCLog.e(TAG, " getVmrInfoList error retCode : " + retCode + " , desc : " + desc);
                    updateVmrList(null);
                }
            });
        }, 50L);
        return vRoot;
    }

    private void initVmrConfList() {
        RecyclerView rvVmrConfList = vRoot.findViewById(R.id.demo_vmr_list_recyclerview);
        adapter = new VmrListItemAdapter(this);
        rvVmrConfList.setAdapter(adapter);
        CustomLayoutManager customLayoutManager = new CustomLayoutManager(getContext());
        customLayoutManager.setSpeedRatio(0.5);
        rvVmrConfList.setLayoutManager(customLayoutManager);
    }

    public void updateVmrList(List<VmrInfoModel> vmrConfList) {
        if (adapter != null) {
            HwmContext.getInstance().runOnMainThread(() -> {
                adapter.updateConfList(vmrConfList);
                View vEmptyTip = vRoot.findViewById(R.id.demo_vmr_list_is_empty);
                if (vmrConfList == null || vmrConfList.isEmpty()) {
                    vEmptyTip.setVisibility(View.VISIBLE);
                } else {
                    vEmptyTip.setVisibility(View.GONE);
                }
            });
        }
    }

    @Override
    public void onDestroy() {
        HCLog.i(TAG, " onDestroy ");
        super.onDestroy();
    }

    @Override
    public void onItemClicked(VmrInfoModel item) {
        HCLog.i(TAG, " onItemClicked : " + item.getName());
        Activity currentActivity = HCActivityManager.getInstance().getCurActivity();
        if (null != currentActivity) {
            Intent intent = new Intent(currentActivity, VmrConfDetailActivity.class);
            intent.putExtra("confid", item.getVmrConferenceId());
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            currentActivity.startActivity(intent);
        }
    }

    @Override
    public void onModifyVmrPwdBtnClicked(VmrInfoModel item) {
        ModifyVmrParam vmrParam = new ModifyVmrParam();
        vmrParam.setGuestPwd(item.getGuestPwd());
        vmrParam.setHostPwd(item.getChairmanPwd());
        vmrParam.setVmrId(item.getVmrId());
        vmrParam.setSubject(item.getName());
        vmrParam.setConfAllowJoinUser(ConfAllowJoinUserType.CONF_ALLOW_JOIN_ANYONE);
        vmrParam.setIsOpenWaitingRoom(false);
        HWMBizSdk.getBizOpenApi().changeVmrInfo(vmrParam, new HwmCallback<Void>() {
            @Override
            public void onSuccess(Void v) {
                HCLog.i(TAG, " changeVmrInfo success ");
                DemoUtil.showToast("修改VMR来宾密码成功");
            }

            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.i(TAG, " changeVmrInfo failed retCode : " + retCode + " , desc : " + desc);
                String err = ErrorMessageFactory.create(retCode);
                if (TextUtils.isEmpty(err)) {
                    err = desc;
                }
                DemoUtil.showToast("修改VMR来宾密码失败：" + err);
            }
        });
    }
}
