package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmdemo.vision.dependency.CustomVisionBizNotificationHandle;

public class MessageFragment extends BaseDialogFragment {
    public final static String TAG = MessageFragment.class.getSimpleName();
    private View vRoot;
    private final IPairCodeChangedListener pairCodeChangedListener = pairCode -> refreshPairCode();

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        vRoot = inflater.inflate(R.layout.sdk_message, container, false);
        refreshPairCode();
        refreshSite();
        CustomVisionBizNotificationHandle.registerPairCodeChangedListener(pairCodeChangedListener);
        return vRoot;
    }

    @Override
    public void onDestroyView() {
        CustomVisionBizNotificationHandle.removePairCodeChangedListener(pairCodeChangedListener);
        super.onDestroyView();
    }

    private void refreshSite() {
        ((TextView) vRoot.findViewById(R.id.tv_current_site))
                .setText("当前站点 " + ((TextUtils.isEmpty(DemoUtil.getCustomSiteAddress())) ? ((DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)
                        ? "国际站"
                        : "国内站"))
                        : (DemoUtil.getCustomSiteAddress() + ":" + DemoUtil.getCustomSitePort())));
    }

    private void refreshPairCode() {
        ((TextView) vRoot.findViewById(R.id.tv_pair_code)).setText("大屏配对码 " + HWMSdk.getOpenApi(DemoUtil.getApplication()).getPairCode());
    }
}
