package com.huawei.hwmdemo.view.sdk;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.cloudlink.openapi.api.param.LoginParam;
import com.huawei.hwmbiz.eventbus.LoginResult;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.utils.PreferencesUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.HwmContext;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmlogger.HCLog;

public class NormalLoginFragment extends BaseDialogFragment {
    public final static String TAG = NormalLoginFragment.class.getSimpleName();

    private Context context;

    View rootView;

    TextView accountView;

    TextView passwordView;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        rootView = inflater.inflate(R.layout.sdk_normal_login, container, false);
        accountView = rootView.findViewById(R.id.account);
        passwordView = rootView.findViewById(R.id.password);
        accountView.setText(PreferencesUtil.getStringPreference(this.getActivity().getApplicationContext(),
            ConfigConstant.KEY_LOGIN_NAME, ""));
        passwordView.setText("");
        Button joinBtn = rootView.findViewById(R.id.btn_2);
        joinBtn.setOnClickListener(this::login);
        return rootView;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.context = context;
    }

    private void login(View v) {
        String account = accountView.getText().toString();
        String password = passwordView.getText().toString();
        if (TextUtils.isEmpty(account) || TextUtils.isEmpty(password)) {
            DemoUtil.showToast("账号和密码不能为空");
            return;
        }
        PreferencesUtil.setStringPreferences(this.getActivity().getApplicationContext(),
            ConfigConstant.KEY_LOGIN_NAME, account);
        showLoading();
        LoginParam loginParam = new LoginParam()
                .setAccount(account)
                .setPassword(password);
        HWMSdk.getOpenApi(getActivity().getApplication()).login(loginParam, new HwmCallback<LoginResult>() {
            @Override
            public void onSuccess(LoginResult loginResult) {
                doDismissDialogAndFragment();
                if (loginResult != null) {
                    DemoUtil.showToast("登录成功" + loginResult.getUserUuid() + "; account:" + loginResult.getAccount()
                        + "; thirdAccount:" + loginResult.getThirdAccount());
                } else {
                    DemoUtil.showToast("已登录");
                }
            }

            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.i(TAG, "login onFailed" + retCode + " " + desc);
                HwmContext.getInstance().runOnMainThread(() -> {
                    String err = ErrorMessageFactory.create(retCode);
                    if (TextUtils.isEmpty(err)) {
                        err = desc;
                    }
                    DemoUtil.showToastDialog("login", retCode, err);
                    doDismissDialogAndFragment();
                });
            }
        });
    }

}
