package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmconf.sdk.util.Utils;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.Foundation;
import com.huawei.hwmsdk.common.SdkCallback;
import com.huawei.hwmsdk.enums.SDKERR;

public class OpenCMSInterfaceTestFragment extends BaseDialogFragment implements View.OnClickListener {

    private EditText editText;

    private final SdkCallback<Boolean> openSubtitleCallback = new SdkCallback<Boolean>() {
        @Override
        public void onFailed(SDKERR error) {
            DemoUtil.showToast("openSubtitle failed, error = " + error);
        }

        @Override
        public void onSuccess(Boolean aBoolean) {
            DemoUtil.showToast("openSubtitle success");
        }
    };

    private final SdkCallback<Boolean> openWaitingRoomCallback = new SdkCallback<Boolean>() {
        @Override
        public void onFailed(SDKERR error) {
            DemoUtil.showToast("openWaiting room failed, error = " + error);
        }

        @Override
        public void onSuccess(Boolean aBoolean) {
            DemoUtil.showToast("openWaiting room success");
        }
    };

    private final SdkCallback<Void> requestHostCallback = new SdkCallback<Void>() {
        @Override
        public void onFailed(SDKERR error) {
            DemoUtil.showToast("request host failed, error = " + error);
        }

        @Override
        public void onSuccess(Void unused) {
            DemoUtil.showToast("request host success");
        }
    };

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.open_cms_interface_test, container);
        Button openSubtitle = rootView.findViewById(R.id.sdk_open_subtitle);
        openSubtitle.setOnClickListener(this);
        Button closeSubtitle = rootView.findViewById(R.id.sdk_closes_subtitle);
        closeSubtitle.setOnClickListener(this);
        Button openWaitingRoom = rootView.findViewById(R.id.sdk_open_waiting_room);
        openWaitingRoom.setOnClickListener(this);
        Button closeWaitingRoom = rootView.findViewById(R.id.sdk_close_waiting_room);
        closeWaitingRoom.setOnClickListener(this);
        Button requestHost = rootView.findViewById(R.id.sdk_request_host);
        requestHost.setOnClickListener(this);
        Button openVirtualBackground = rootView.findViewById(R.id.sdk_open_virtual_background_page);
        openVirtualBackground.setOnClickListener(this);
        Button getSubtitleOpened = rootView.findViewById(R.id.get_subtitle_opened);
        getSubtitleOpened.setOnClickListener(this);
        Button getWaitingRoomOpened = rootView.findViewById(R.id.get_waiting_room_opened);
        getWaitingRoomOpened.setOnClickListener(this);
        Button getVirtualBackgroundOpened = rootView.findViewById(R.id.get_virtual_background_opened);
        getVirtualBackgroundOpened.setOnClickListener(this);
        if (Foundation.isIsRoomsMode()) {
            openVirtualBackground.setVisibility(View.GONE);
        }

        editText = rootView.findViewById(R.id.sdk_host_password);

        return rootView;
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.sdk_open_subtitle) {
            HWMSdk.getOpenApi(Utils.getApp()).openSubtitle(true, openSubtitleCallback);
        } else if (view.getId() == R.id.sdk_closes_subtitle) {
            HWMSdk.getOpenApi(Utils.getApp()).openSubtitle(false, openSubtitleCallback);
        } else if (view.getId() == R.id.sdk_open_waiting_room) {
            HWMBizSdk.getBizOpenApi().openWaitingRoom(true, openWaitingRoomCallback);
        } else if (view.getId() == R.id.sdk_close_waiting_room) {
            HWMBizSdk.getBizOpenApi().openWaitingRoom(false, openWaitingRoomCallback);
        } else if (view.getId() == R.id.sdk_request_host) {
            HWMBizSdk.getBizOpenApi().applyHostRole(editText.getText().toString(), requestHostCallback);
        } else if (view.getId() == R.id.sdk_open_virtual_background_page) {
            SDKERR sdkerr = HWMSdk.getOpenApi(DemoUtil.getApplication()).openVirtualBackgroundPage();
            DemoUtil.showToast("openVirtualBackgroundPage sdkerr = " + sdkerr);
        } else if (view.getId() == R.id.get_subtitle_opened) {
            boolean isOpen = HWMSdk.getOpenApi(Utils.getApp()).getSubtitlePageOpened();
            DemoUtil.showToast("getSubtitlePageOpened, isOpen : " + isOpen);
        } else if (view.getId() == R.id.get_waiting_room_opened) {
            boolean isOpen = HWMBizSdk.getBizOpenApi().getWaitingRoomOpened();
            DemoUtil.showToast("getWaitingRoomOpened, isOpen : " + isOpen);
        } else if (view.getId() == R.id.get_virtual_background_opened) {
            boolean isOpen = HWMSdk.getOpenApi(Utils.getApp()).getVirtualBackgroundSettingPageOpened();
            DemoUtil.showToast("getVirtualBackgroundSettingPageOpened, isOpen : " + isOpen);
        }
    }
}
