package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmconf.presentation.error.ErrorMessageFactory;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmfoundation.callback.HwmCallbackWithErrorData;
import com.huawei.hwmsdk.enums.SDKERR;
import com.huawei.hwmsdk.model.param.StartProjectionParam;
import com.huawei.hwmsdk.model.result.StartProjectionFailedInfo;

import java.util.Locale;

public class ProjectionInConfFragment extends BaseDialogFragment {
    private EditText pairCodeEditText;
    private Button pairButton;
    private ViewGroup verificationCodeArea;
    private EditText verificationCodeEditText;
    private View pairCodeArea;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        View rootView = inflater.inflate(R.layout.fragment_offline_controller, container, false);
        pairCodeArea = rootView.findViewById(R.id.pair_code_area);
        pairCodeEditText = rootView.findViewById(R.id.pair_code_input);
        verificationCodeArea = rootView.findViewById(R.id.verification_code_area);
        verificationCodeEditText = rootView.findViewById(R.id.verification_code_input);

        verificationCodeArea.setVisibility(View.GONE);

        pairButton = rootView.findViewById(R.id.pair_btn);
        pairButton.setOnClickListener(view -> startProjection());
        return rootView;
    }

    private void startProjection() {
        showLoading();
        StartProjectionParam param = new StartProjectionParam()
            .setPairCode(pairCodeEditText.getText().toString().toUpperCase(Locale.ROOT));
        HWMSdk.getOpenApi(DemoUtil.getApplication()).startProjection(param, new HwmCallbackWithErrorData<Void, StartProjectionFailedInfo>() {
            @Override
            public void onFailed(int retCode, String desc, StartProjectionFailedInfo errorData) {
                dismissLoading();
                if (retCode == SDKERR.USG_PROJECTION_CROSS_CORP.getValue()) {
                    DemoUtil.showToast("请输入验证码");
                    pairCodeArea.setVisibility(View.GONE);
                    verificationCodeArea.setVisibility(View.VISIBLE);
                    pairCodeEditText.clearFocus();
                    verificationCodeEditText.clearFocus();
                    pairButton.setText("验证");
                    pairButton.setOnClickListener(view -> checkVerificationCode(errorData));
                    return;
                }
                String err = ErrorMessageFactory.create(retCode);
                if (!TextUtils.isEmpty(err)) {
                    desc = err;
                }
                DemoUtil.showToastDialog("会中投屏", retCode, desc);
            }

            @Override
            public void onSuccess(Void v) {
                dismissLoading();
            }
        });
    }

    private void checkVerificationCode(StartProjectionFailedInfo errorData) {
        showLoading();
        StartProjectionParam param = new StartProjectionParam()
            .setVerifyCode(verificationCodeEditText.getText().toString())
            .setRandomNumber(errorData.getRandomNumber());
        HWMSdk.getOpenApi(DemoUtil.getApplication()).startProjection(param, new HwmCallbackWithErrorData<Void, StartProjectionFailedInfo>() {
            @Override
            public void onFailed(int retCode, String desc, StartProjectionFailedInfo errorData) {
                dismissLoading();
                String err = ErrorMessageFactory.create(retCode);
                if (!TextUtils.isEmpty(err)) {
                    desc = err;
                }
                DemoUtil.showToastDialog("会中投屏", retCode, desc);
            }

            @Override
            public void onSuccess(Void v) {
                dismissLoading();
            }
        });
    }
}
