package com.huawei.hwmdemo.view.sdk;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.EditText;
import android.widget.RadioGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.enums.NetworkAccessType;

public class SelectSiteFragment extends BaseDialogFragment {

    public final static String TAG = ServerSettingFragment.class.getSimpleName();

    private RadioGroup mRgSite;

    private View mCustomSiteContainer;

    private EditText mEtCustomSiteAddress;

    private EditText mEtCustomSitePort;

    private RadioGroup mRgProxyType;

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.fragment_select_site, container, false);
        mRgSite = vRoot.findViewById(R.id.rg_site);
        mCustomSiteContainer = vRoot.findViewById(R.id.ll_custom_site_container);
        mEtCustomSiteAddress = vRoot.findViewById(R.id.et_custom_site_address);
        mEtCustomSitePort = vRoot.findViewById(R.id.et_custom_site_port);
        mRgProxyType = vRoot.findViewById(R.id.rg_proxy_type);
        initRadioGroup();
        View btnSave = vRoot.findViewById(R.id.btn_save);
        btnSave.setEnabled(!HWMSdk.getOpenApi(DemoUtil.getApplication()).isActivated());
        btnSave.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mRgSite.getCheckedRadioButtonId() == R.id.rb_custom) {
                    String customSiteAddress = mEtCustomSiteAddress.getText().toString().trim();
                    String customSitePort = mEtCustomSitePort.getText().toString().trim();
                    if (TextUtils.isEmpty(customSiteAddress)) {
                        DemoUtil.showToast("请输入有效地址");
                        return;
                    }
                    if (TextUtils.isEmpty(customSitePort) || TextUtils.equals("0", customSitePort)) {
                        DemoUtil.showToast("请输入有效端口号");
                        return;
                    }
                    DemoUtil.setCustomSiteAddress(customSiteAddress);
                    DemoUtil.setCustomSitePort(Integer.parseInt(customSitePort));
                    DemoUtil.setCustomSiteProxy(getNetworkAccessType());
                } else {
                    DemoUtil.setCustomSiteAddress("");
                    DemoUtil.setCustomSitePort(0);
                    DemoUtil.setCustomSiteProxy(NetworkAccessType.ACCESS_TYPE_AUTO);
                }
                DemoUtil.setCustom(NeedCustomType.SITE_TYPE_STRATEGY, mRgSite.getCheckedRadioButtonId() == R.id.rb_ap);
                dismiss();
                showLoading();
                new Handler(Looper.getMainLooper()).postDelayed(() -> {
                    dismissLoading();
                    DemoUtil.restartApplication();
                }, 1500L);
            }
        });
        return vRoot;
    }

    @NonNull
    private NetworkAccessType getNetworkAccessType() {
        NetworkAccessType customSiteProxy;
        if (mRgProxyType.getCheckedRadioButtonId() == R.id.rb_proxy_inner) {
            customSiteProxy = NetworkAccessType.ACCESS_TYPE_INNER;
        } else if (mRgProxyType.getCheckedRadioButtonId() == R.id.rb_proxy_outer) {
            customSiteProxy = NetworkAccessType.ACCESS_TYPE_OUTER;
        } else {
            customSiteProxy = NetworkAccessType.ACCESS_TYPE_AUTO;
        }
        return customSiteProxy;
    }

    private void initRadioGroup() {
        mRgSite.setOnCheckedChangeListener(new RadioGroup.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(RadioGroup group, int checkedId) {
                if (checkedId == R.id.rb_custom) {
                    mCustomSiteContainer.setVisibility(View.VISIBLE);
                    refreshCustomSite();
                } else {
                    mCustomSiteContainer.setVisibility(View.GONE);
                }
            }
        });
        if (!TextUtils.isEmpty(DemoUtil.getCustomSiteAddress()) && DemoUtil.getCustomSitePort() != 0) {
            mRgSite.check(R.id.rb_custom);
            refreshCustomSite();
        } else if (DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)) {
            mRgSite.check(R.id.rb_ap);
        } else {
            mRgSite.check(R.id.rb_cn);
        }
    }

    private void refreshCustomSite() {
        String customSiteAddress = DemoUtil.getCustomSiteAddress();
        int customSitePort = DemoUtil.getCustomSitePort();
        if (!TextUtils.isEmpty(customSiteAddress)) {
            mEtCustomSiteAddress.setText(customSiteAddress);
        }
        if (customSitePort != 0) {
            mEtCustomSitePort.setText(String.valueOf(customSitePort));
        }
        if (DemoUtil.getCustomSiteProxy() == NetworkAccessType.ACCESS_TYPE_INNER) {
            mRgProxyType.check(R.id.rb_proxy_inner);
        } else if (DemoUtil.getCustomSiteProxy() == NetworkAccessType.ACCESS_TYPE_OUTER) {
            mRgProxyType.check(R.id.rb_proxy_outer);
        } else {
            mRgProxyType.check(R.id.rb_proxy_auto);
        }
    }
}
