package com.huawei.hwmdemo.view.sdk;


import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.RadioGroup;
import android.widget.Switch;

import androidx.annotation.NonNull;

import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.constant.ConfigConstant;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.base.BaseDialogFragment;
import com.huawei.hwmsdk.enums.NetworkAccessType;


public class ServerSettingFragment extends BaseDialogFragment {
    public final static String TAG = ServerSettingFragment.class.getSimpleName();

    private EditText mEtCustomSiteAddress;

    private EditText mEtCustomSitePort;

    private RadioGroup mRgProxyType;

    private Switch mSwitchCaCheck;

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (getDialog() != null) {
            getDialog().requestWindowFeature(Window.FEATURE_NO_TITLE);
        }
        View vRoot = inflater.inflate(R.layout.server_setting_layout, container, false);
        mEtCustomSiteAddress = vRoot.findViewById(R.id.server_address_input);
        mEtCustomSitePort = vRoot.findViewById(R.id.server_port_input);
        mRgProxyType = vRoot.findViewById(R.id.rg_proxy_type);
        mSwitchCaCheck = vRoot.findViewById(R.id.checked_ssl);
        initViews();
        vRoot.findViewById(R.id.save_btn).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                handleSaveButtonClicked();
            }
        });
        return vRoot;
    }

    private void initViews() {
        if (DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)) {
            mEtCustomSiteAddress.setText(ConfigConstant.INTERNATIONAL_SERVER_ADDRESS);
        } else {
            mEtCustomSiteAddress.setText(TextUtils.isEmpty(DemoUtil.getCustomSiteAddress()) ? ConfigConstant.CHINA_SERVER_ADDRESS : DemoUtil.getCustomSiteAddress());
        }
        String customServerPort = String.valueOf(DemoUtil.getCustomSitePort());
        mEtCustomSitePort.setText(TextUtils.equals(customServerPort, "0") ? ConfigConstant.COMMON_SERVER_PORT : customServerPort);
        mSwitchCaCheck.setChecked(DemoUtil.needCustom(NeedCustomType.SITE_CA_CHECK, true));
        mSwitchCaCheck.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                DemoUtil.setCustom(NeedCustomType.SITE_CA_CHECK, isChecked);
            }
        });
        NetworkAccessType customSiteProxy = DemoUtil.getCustomSiteProxy();
        if (customSiteProxy == NetworkAccessType.ACCESS_TYPE_INNER) {
            mRgProxyType.check(R.id.rb_proxy_inner);
        } else if (customSiteProxy == NetworkAccessType.ACCESS_TYPE_OUTER) {
            mRgProxyType.check(R.id.rb_proxy_outer);
        } else {
            mRgProxyType.check(R.id.rb_proxy_auto);
        }
    }

    private void handleSaveButtonClicked() {
        String customSiteAddress = mEtCustomSiteAddress.getText().toString().trim();
        String customSitePort = mEtCustomSitePort.getText().toString().trim();
        if (TextUtils.isEmpty(customSiteAddress) || TextUtils.isEmpty(customSitePort) || TextUtils.equals("0", customSitePort)) {
            DemoUtil.showToast("未输入有效地址/端口号，使用国内站地址");
            resetCustomServerSetting();
        } else if (TextUtils.equals(customSiteAddress, ConfigConstant.CHINA_SERVER_ADDRESS) && TextUtils.equals(customSitePort, ConfigConstant.COMMON_SERVER_PORT)) {
            DemoUtil.showToast("使用国内站地址");
            resetCustomServerSetting();
        } else {
            DemoUtil.showToast("应用进程重启后地址和端口修改生效");
            DemoUtil.setCustom(NeedCustomType.SITE_TYPE_STRATEGY, TextUtils.equals(ConfigConstant.INTERNATIONAL_SERVER_ADDRESS, customSiteAddress));
            DemoUtil.setCustom(NeedCustomType.SITE_CA_CHECK, mSwitchCaCheck.isChecked());
            DemoUtil.setCustomSiteAddress(customSiteAddress);
            DemoUtil.setCustomSitePort(Integer.parseInt(customSitePort));
            NetworkAccessType customSiteProxy;
            int checkedRadioButtonId = mRgProxyType.getCheckedRadioButtonId();
            if (checkedRadioButtonId == R.id.rb_proxy_inner) {
                customSiteProxy = NetworkAccessType.ACCESS_TYPE_INNER;
            } else if (checkedRadioButtonId == R.id.rb_proxy_outer) {
                customSiteProxy = NetworkAccessType.ACCESS_TYPE_OUTER;
            } else {
                customSiteProxy = NetworkAccessType.ACCESS_TYPE_AUTO;
            }
            DemoUtil.setCustomSiteProxy(customSiteProxy);
        }
        dismiss();
        showLoading();
        new Handler(Looper.getMainLooper()).postDelayed(() -> {
            dismissLoading();
            DemoUtil.restartApplication();
        }, 1500L);
    }

    private static void resetCustomServerSetting() {
        DemoUtil.setCustom(NeedCustomType.SITE_TYPE_STRATEGY, false);
        DemoUtil.setCustom(NeedCustomType.SITE_CA_CHECK, true);
        DemoUtil.setCustomSiteAddress("");
        DemoUtil.setCustomSitePort(0);
        DemoUtil.setCustomSiteProxy(NetworkAccessType.ACCESS_TYPE_AUTO);
    }
}
