package com.huawei.hwmdemo.view.sdkconfig;

import android.annotation.SuppressLint;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.huawei.hwmbiz.HWMBizSdk;
import com.huawei.hwmbiz.contact.api.impl.DepartmentInfoImpl;
import com.huawei.hwmbiz.contact.cache.DepartmentTreeInfoCache;
import com.huawei.hwmbiz.contact.cache.model.CorporateContactInfoModel;
import com.huawei.hwmconf.presentation.view.component.CustomLayoutManager;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.adapter.PeopleListItemAdapter;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.BaseActivity;
import com.huawei.hwmfoundation.HwmContext;
import com.huawei.hwmfoundation.callback.HwmCallback;
import com.huawei.hwmlogger.HCLog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;


public class VisionAddAttendeesActivity extends BaseActivity {
    public final static String TAG = VisionAddAttendeesActivity.class.getSimpleName();
    private PeopleListItemAdapter attendeeAdapter;
    private List<CorporateContactInfoModel> allLevelTotalList;

    @SuppressLint("CheckResult")
    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.customize_vision_add_attendee);
        /**
         *
         * ----------------------------该API仅供参考使用，开发过程中请勿使用此API------------------------------------
         * DepartmentTreeInfoCache.getInstance(DemoUtil.getApplication()).getMyDepartmentCode()，获取当前登录账号所在的部门编码
         * DepartmentInfoImpl.getInstance(DemoUtil.getApplication()).downloadDepartmentContactInfo,获取部门下所有成员列表（包含子部门）
         *
         */
        showLoading();
        DepartmentTreeInfoCache.getInstance(DemoUtil.getApplication()).getMyDepartmentCode()
                .subscribe(departmentCode -> DepartmentInfoImpl.getInstance(DemoUtil.getApplication()).downloadDepartmentContactInfo(departmentCode, 1)
                        .subscribe(departmentContactInfoModel -> {
                            allLevelTotalList = departmentContactInfoModel.getAllLevelTotalList();
                            List<AttendeeModel> attendeeModels = new ArrayList<>();
                            for (int i = 0; i < allLevelTotalList.size(); i++) {
                                AttendeeModel attendeeModel = new AttendeeModel();
                                attendeeModel.setName(allLevelTotalList.get(i).getName());
                                attendeeModel.setEmail(allLevelTotalList.get(i).getEmail());
                                attendeeModel.setAccountId(allLevelTotalList.get(i).getAccount());
                                attendeeModel.setNumber(allLevelTotalList.get(i).getBindNum());
                                attendeeModels.add(attendeeModel);
                            }
                            updateMeetingList(attendeeModels);
                            dismissLoading();
                        }), throwable -> {
                    HCLog.e(TAG, " downloadDepartmentContactInfo error : " + throwable);
                    DemoUtil.showToast("获取联系人列表失败");
                    dismissLoading();
                });
        /**
         * ----------------------------------------------------------------------------------------------------------------
         */

        RecyclerView rvAddAttendee = findViewById(R.id.rv_add_attendee);
        Button btnConfirm = findViewById(R.id.btn_confirm);
        Button btnCancel = findViewById(R.id.btn_cancel);
        attendeeAdapter = new PeopleListItemAdapter();
        if (rvAddAttendee != null) {
            rvAddAttendee.setAdapter(attendeeAdapter);
            CustomLayoutManager customLayoutManager = new CustomLayoutManager(getApplicationContext());
            customLayoutManager.setSpeedRatio(0.5);
            rvAddAttendee.setLayoutManager(customLayoutManager);
        }

        attendeeAdapter.setOnItemClickListener((view, position) -> attendeeAdapter.setSelectItem(position));

        btnConfirm.setOnClickListener(v -> {
            List<AttendeeModel> selectedAttendees = new ArrayList<>();
            Map<Integer, Boolean> map = attendeeAdapter.getMap();
            for (int i = 0; i < map.size(); i++) {
                if (Boolean.TRUE.equals(map.get(i))) {
                    AttendeeModel hwmAttendeeInfo = new AttendeeModel();
                    hwmAttendeeInfo.setName(allLevelTotalList.get(i).getName());
                    hwmAttendeeInfo.setEmail(allLevelTotalList.get(i).getEmail());
                    hwmAttendeeInfo.setAccountId(allLevelTotalList.get(i).getAccount());
                    hwmAttendeeInfo.setNumber(allLevelTotalList.get(i).getBindNum());
                    selectedAttendees.add(hwmAttendeeInfo);
                }
            }
            addSelectedAttendees(selectedAttendees);
        });

        btnCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    private void addSelectedAttendees(List<AttendeeModel> selectedAttendees) {
        showLoading();
        HWMBizSdk.getBizOpenApi().addAttendee(selectedAttendees, new HwmCallback<Integer>() {
            @Override
            public void onFailed(int retCode, String desc) {
                HCLog.e(TAG, " addSelectedAttendees error retCode : " + retCode + " , desc : " + desc);
                DemoUtil.showToast("添加与会者失败：" + desc);
                dismissLoading();
            }

            @Override
            public void onSuccess(Integer integer) {
                DemoUtil.showToast("添加与会者成功");
                dismissLoading();
                finish();
            }
        });
    }

    public void updateMeetingList(List<AttendeeModel> attendeeModels) {
        if (attendeeAdapter != null) {
            HwmContext.getInstance().runOnMainThread(() -> attendeeAdapter.updateConfList(attendeeModels));
        }
    }
}

