package com.huawei.hwmdemo.vision.delegate;

import android.app.Activity;
import android.app.Application;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.text.TextUtils;

import androidx.annotation.NonNull;

import com.huawei.cloudlink.openapi.OpenSDKConfig;
import com.huawei.cloudlink.smartrooms.openapi.api.IServerSettingStrategy;
import com.huawei.hwmbiz.dependency.IOpenProductAbilityStrategy;
import com.huawei.hwmbiz.dependency.ISiteTypeStrategy;
import com.huawei.hwmbiz.setting.SiteType;
import com.huawei.hwmconf.presentation.dependency.IDeviceStrategyWhenConfAccept;
import com.huawei.hwmconf.presentation.dependency.IIncomingHandle;
import com.huawei.hwmconf.presentation.dependency.IMeetingUiCustomizationStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IAudienceMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IParticipantMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IToolbarMenuStrategy;
import com.huawei.hwmconf.presentation.dependency.menu.v2.buildin.toolbar.ToolBarMenuProxy;
import com.huawei.hwmconf.presentation.model.HWMIncomingAnswerType;
import com.huawei.hwmdemo.delegate.IHwmUiDelegate;
import com.huawei.hwmdemo.dependency.CustomLoggerHandle;
import com.huawei.hwmdemo.dependency.NeedCustomType;
import com.huawei.hwmdemo.model.ApiPageModel;
import com.huawei.hwmdemo.model.FeaturePage;
import com.huawei.hwmdemo.model.MenuGroup;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.DemoActivity;
import com.huawei.hwmdemo.view.sdk.ActivateFragment;
import com.huawei.hwmdemo.view.sdk.CreateMeetingFragment;
import com.huawei.hwmdemo.view.sdk.DeviceResourceFragment;
import com.huawei.hwmdemo.view.sdk.JoinMeetingFragment;
import com.huawei.hwmdemo.view.sdk.ListMeetingFragment;
import com.huawei.hwmdemo.view.sdk.LogPathFragment;
import com.huawei.hwmdemo.view.sdk.MeetingSettingFragment;
import com.huawei.hwmdemo.view.sdk.MeetingUiFragment;
import com.huawei.hwmdemo.view.sdk.MessageFragment;
import com.huawei.hwmdemo.view.sdk.OpenCMSInterfaceTestFragment;
import com.huawei.hwmdemo.view.sdk.SDKListFragment;
import com.huawei.hwmdemo.view.sdk.SelectModeFragment;
import com.huawei.hwmdemo.view.sdk.SelectSiteFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.AudienceMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.AudioConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.FloatingMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.ParticipantMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.VideoConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.view.sdkconfig.menu.WebinarConfToolbarMenuConfigFragment;
import com.huawei.hwmdemo.vision.dependency.CustomVisionBizNotificationHandle;
import com.huawei.hwmdemo.vision.dependency.CustomVisionNotifyHandler;
import com.huawei.hwmdemo.vision.dependency.menu.audience.CustomVisionAudienceMenuHandle;
import com.huawei.hwmdemo.vision.dependency.menu.participant.CustomVisionParticipantMenuHandle;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle.CustomVisionConfAudioToolbarHandle;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle.CustomVisionConfVideoToolbarHandle;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle.CustomVisionConfWebinarToolbarHandle;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.handle.CustomVisionFloatingToolbarHandle;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.listener.CustomVisionOnMenuItemClickListener;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionAudienceMenuHandleWrapper;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionConfAudioToolbarHandleWrapper;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionConfVideoToolbarHandleWrapper;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionConfWebinarToolbarHandleWrapper;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionFloatingMenuHandleWrapper;
import com.huawei.hwmdemo.vision.dependency.menu.toolbar.wrapper.CustomVisionParticipantMenuHandleWrapper;
import com.huawei.hwmdemo.vision.utils.ModeUtil;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmsdk.enums.HardCodecMode;
import com.huawei.hwmsdk.enums.NetworkAccessType;

import java.util.ArrayList;
import java.util.List;

public class VisionUiDelegate implements IHwmUiDelegate {

    private static final String TAG = "VisionUiDelegate";

    private final Application application;

    public VisionUiDelegate(Application application) {
        this.application = application;
    }

    @Override
    public void initOpenSdkUIConfig(OpenSDKConfig sdkConfig) {
        //自定义日志路径
        configCustomLogHandle(sdkConfig);
        //自定义来电处理
        configCustomInComingHandle(sdkConfig);
        //自定义菜单（自定义加人）
        configCustomMenu(sdkConfig);
        //自定义设备策略
        configDeviceStrategy(sdkConfig);
        //自定义接入站点
        configCustomSiteTypeStrategy(sdkConfig);
        //自定义会中通知
        configCustomBizNotification(sdkConfig);
        configCustomNotifyHandle(sdkConfig);
        //自定义能力规格
        configCustomProductAbilityStrategy(sdkConfig);
        //自定义是否是遥控器模式
        configCustomRemoteMode(sdkConfig);
        //会议设置
        configSettingInMeeting(sdkConfig);
        //会中界面特殊定制
        configMeetingUiCustomization(sdkConfig);
    }

    private void configMeetingUiCustomization(OpenSDKConfig sdkConfig) {
        sdkConfig.setMeetingUiCustomizationStrategy(new IMeetingUiCustomizationStrategy() {
            @Override
            public boolean onStartScreenShareClicked(Activity currentActivity) {
                return handleStartScreenShareClicked(currentActivity);
            }
        });
    }

    private boolean handleStartScreenShareClicked(Activity currentActivity) {
        if (DemoUtil.needCustom(NeedCustomType.VISION_SCREEN_SHARE_JUMP_TO_MAIN_ACTIVITY, false)) {
            if (currentActivity != null) {
                boolean currentActivityIsMainActivity = currentActivity instanceof DemoActivity;
                if (!currentActivityIsMainActivity) {
                    if (currentActivity.isTaskRoot()) {
                        Intent intent = new Intent(currentActivity, DemoActivity.class);
                        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        currentActivity.startActivity(intent);
                    }
                    currentActivity.finish();
                }
            }
            return true;
        }
        return false;
    }

    private void configSettingInMeeting(OpenSDKConfig sdkConfig) {
        sdkConfig.setDefaultVideoLayoutPIP(DemoUtil.needCustom(NeedCustomType.VISION_DEFAULT_VIDEO_LAYOUT_PIP));
    }

    private void configCustomRemoteMode(OpenSDKConfig sdkConfig) {
        sdkConfig.setRemoteControlMode(DemoUtil.needCustom(NeedCustomType.REMOTE_MODE));
    }

    private void configCustomProductAbilityStrategy(OpenSDKConfig sdkConfig) {
        sdkConfig.setHighResolutionFirst(DemoUtil.needCustom(NeedCustomType.HIGH_RESOLUTION_FIRST));
        sdkConfig.setOpenProductAbilityStrategy(new IOpenProductAbilityStrategy() {
            @Override
            public boolean isHardCodecForced() {
                return DemoUtil.needCustom(NeedCustomType.FORCE_HARD_CODEC);
            }

            @Override
            public HardCodecMode hardCodecMode() {
                return DemoUtil.getHardCodecMode();
            }

            @Override
            public int maxGalleryVideoViewCount() {
                return PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_GALLERY_VIDEO_COUNT, 4, DemoUtil.getApplication());
            }

            @Override
            public int maxPresenterVideoViewCount() {
                return PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.MAX_PRESENTER_VIDEO_COUNT, 4, DemoUtil.getApplication());
            }

            @Override
            public boolean isShowControllerQrInMeeting() {
                return DemoUtil.needCustom(NeedCustomType.VISION_SHOW_CONTROLLER_QR);
            }

            @Override
            public boolean isScreenShareDisabled() {
                return DemoUtil.needCustom(NeedCustomType.DISABLE_SCREEN_SHARE);
            }

            @Override
            public boolean isMeetingAudioSharingCaptureDisabled() {
                return DemoUtil.needCustom(NeedCustomType.DISABLE_SCREEN_SHARE_AUDIO_CAPTURE);
            }

            @Override
            public boolean isAddressBookDisabled() {
                return DemoUtil.needCustom(NeedCustomType.VISION_ADDRESS_BOOK_DISABLED, false);
            }
        });
    }

    private void configCustomBizNotification(OpenSDKConfig sdkConfig) {
        sdkConfig.setBizNotificationHandler(new CustomVisionBizNotificationHandle());
    }

    private void configCustomNotifyHandle(OpenSDKConfig sdkConfig) {
        sdkConfig.setNotifyHandler(new CustomVisionNotifyHandler());
    }

    private void configCustomSiteTypeStrategy(OpenSDKConfig sdkConfig) {
        sdkConfig.setSiteTypeStrategy(new ISiteTypeStrategy() {
            @Override
            public SiteType getSiteType() {
                return DemoUtil.needCustom(NeedCustomType.SITE_TYPE_STRATEGY)
                        ? SiteType.SITE_TYPE_HEC_AP
                        : SiteType.SITE_TYPE_HEC_CN;
            }
        });

        // 自定义站点 和 代理模式
        if (!TextUtils.isEmpty(DemoUtil.getCustomSiteAddress()) && DemoUtil.getCustomSitePort() != 0) {
            sdkConfig.setServerSettingStrategy(new IServerSettingStrategy() {
                @Override
                public String getServerAddress() {
                    return DemoUtil.getCustomSiteAddress();
                }

                @Override
                public int getServerPort() {
                    return DemoUtil.getCustomSitePort();
                }

                @Override
                public NetworkAccessType getProxyType() {
                    return DemoUtil.getCustomSiteProxy();
                }
            });
        }
    }

    private void configCustomLogHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.LOGGER_PATH)) {
            sdkConfig.setLoggerHandle(new CustomLoggerHandle(application));
        }
    }

    private void configCustomInComingHandle(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.SHOW_CUSTOM_INCOMING)) {
            sdkConfig.setInComingHandle(new IIncomingHandle() {
                @Override
                public HWMIncomingAnswerType answerTypeOnCallIncoming() {
                    return null;
                }

                @Override
                public HWMIncomingAnswerType answerTypeOnConfIncoming() {
                    return HWMIncomingAnswerType.valueOf(PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, NeedCustomType.SHOW_CUSTOM_INCOMING_CONF,
                            HWMIncomingAnswerType.HWM_IMCOMING_NORMAL.getType(), application));
                }
            });
        }
    }

    private void configDeviceStrategy(OpenSDKConfig sdkConfig) {
        sdkConfig.setDeviceStrategyWhenConfAccept(new IDeviceStrategyWhenConfAccept() {

            @Override
            public boolean isTurnOnCameraWhenConfAccept() {
                return DemoUtil.needCustom(NeedCustomType.CONF_OPEN_CAMERA);
            }

            @Override
            public boolean isTurnOnMicWhenConfAccept() {
                return DemoUtil.needCustom(NeedCustomType.CONF_OPEN_MIC);
            }
        });
    }

    private void configCustomMenu(OpenSDKConfig sdkConfig) {
        if (DemoUtil.needCustom(NeedCustomType.CONF_MENU)) {
            ToolBarMenuProxy toolBarMenuProxy = new ToolBarMenuProxy();
            //定制 音频会议的会中toolbar菜单
            toolBarMenuProxy.setConfAudioToolbarHandle(new CustomVisionConfAudioToolbarHandleWrapper());
            //定制 视频会议的会中toolbar菜单
            toolBarMenuProxy.setConfVideoToolbarHandle(new CustomVisionConfVideoToolbarHandleWrapper());
            //定制 网络研讨会的会中toolbar菜单
            toolBarMenuProxy.setConfWebinarToolbarHandle(new CustomVisionConfWebinarToolbarHandleWrapper());
            sdkConfig.setToolBarMenuProxy(toolBarMenuProxy);
            //定制会中入会者列表界面的菜单
            sdkConfig.setParticipantMenuStrategy(new CustomVisionParticipantMenuHandleWrapper());
            // 定制会中观众列表界面的菜单
            sdkConfig.setAudienceMenuStrategy(new CustomVisionAudienceMenuHandleWrapper());
            // 定制会中悬浮窗toolbar菜单
            sdkConfig.setFloatingToolBarMenuProxy(new CustomVisionFloatingMenuHandleWrapper());
            //自定义菜单的点击事件处理
            sdkConfig.setOnMenuItemClickListener(new CustomVisionOnMenuItemClickListener());
        }
    }

    @Override
    public int getScreenOrientation() {
        return ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;
    }

    @NonNull
    @Override
    public List<FeaturePage> getHomePages() {
        ArrayList<FeaturePage> pages = new ArrayList<>();
        pages.add(new FeaturePage("SDK集成Demo", new SDKListFragment()));
        return pages;
    }

    @NonNull
    @Override
    public List<ApiPageModel> getSdkApiFeatures() {
        ArrayList<ApiPageModel> features = new ArrayList<>();
        if (ModeUtil.getSupportedModeTypes().size() >= 2) {
            features.add(new ApiPageModel("模式切换", SelectModeFragment.class));
        }
        features.add(new ApiPageModel("站点选择", SelectSiteFragment.class));
        features.add(new ApiPageModel("激活信息", ActivateFragment.class));
        features.add(new ApiPageModel("会议设置", MeetingSettingFragment.class));
        features.add(new ApiPageModel("会议界面", MeetingUiFragment.class));
        features.add(new ApiPageModel("日志路径", LogPathFragment.class));
        features.add(new ApiPageModel("信息汇总", MessageFragment.class));
        features.add(new ApiPageModel("创建会议", CreateMeetingFragment.class));
        features.add(new ApiPageModel("加入会议", JoinMeetingFragment.class));
        features.add(new ApiPageModel("会议列表", ListMeetingFragment.class));
        features.add(new ApiPageModel("会议资源", DeviceResourceFragment.class));
        features.add(new ApiPageModel("开放会控接口", OpenCMSInterfaceTestFragment.class));
        features.add(new ApiPageModel("拉起会中主界面", null));
        return features;
    }

    @NonNull
    @Override
    public List<FeaturePage> getMenuConfigPages() {
        ArrayList<FeaturePage> pages = new ArrayList<>();
        VideoConfToolbarMenuConfigFragment videoConfToolbarMenuConfigFragment = new VideoConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(videoConfToolbarMenuConfigFragment.getName(), videoConfToolbarMenuConfigFragment));
        AudioConfToolbarMenuConfigFragment audioConfToolbarMenuConfigFragment = new AudioConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(audioConfToolbarMenuConfigFragment.getName(), audioConfToolbarMenuConfigFragment));
        WebinarConfToolbarMenuConfigFragment webinarConfToolbarMenuConfigFragment = new WebinarConfToolbarMenuConfigFragment();
        pages.add(new FeaturePage(webinarConfToolbarMenuConfigFragment.getName(), webinarConfToolbarMenuConfigFragment));
        ParticipantMenuConfigFragment participantMenuConfigFragment = new ParticipantMenuConfigFragment();
        pages.add(new FeaturePage(participantMenuConfigFragment.getName(), participantMenuConfigFragment));
        AudienceMenuConfigFragment audienceMenuConfigFragment = new AudienceMenuConfigFragment();
        pages.add(new FeaturePage(audienceMenuConfigFragment.getName(), audienceMenuConfigFragment));
        FloatingMenuConfigFragment floatingMenuConfigFragment = new FloatingMenuConfigFragment();
        pages.add(new FeaturePage(floatingMenuConfigFragment.getName(), floatingMenuConfigFragment));
        return pages;
    }

    @NonNull
    @Override
    public List<MenuGroup> getVideoMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomVisionConfVideoToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getVideoMeetingMenuHandle() {
        return CustomVisionConfVideoToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getAudioMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomVisionConfVideoToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getAudioMeetingMenuHandle() {
        return CustomVisionConfAudioToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getWebinarMeetingMenuFeatures() {
        IToolbarMenuStrategy strategy = new CustomVisionConfWebinarToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("底部菜单项", "buildMenuItems", strategy.buildMenuItems()));
        features.add(new MenuGroup("更多菜单项", "buildMoreMenuItems", strategy.buildMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getWebinarMeetingMenuHandle() {
        return CustomVisionConfWebinarToolbarHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getParticipantMenuFeatures() {
        IParticipantMenuStrategy strategy = new CustomVisionParticipantMenuHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("点击与会者弹窗菜单", "buildParticipantItemMenuItems", strategy.buildParticipantItemMenuItems()));
        features.add(new MenuGroup("点击底部更多弹窗菜单", "buildParticipantToolbarMoreMenuItems", strategy.buildParticipantToolbarMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getParticipantMenuHandle() {
        return CustomVisionParticipantMenuHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getAudienceMenuFeatures() {
        IAudienceMenuStrategy strategy = new CustomVisionAudienceMenuHandle();
        List<MenuGroup> features = new ArrayList<>();
        features.add(new MenuGroup("点击观众弹窗菜单", "buildAudienceItemMenuItems", strategy.buildAudienceItemMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getAudienceMenuHandle() {
        return CustomVisionAudienceMenuHandle.class.getName();
    }

    @NonNull
    @Override
    public List<MenuGroup> getFloatingMenuFeatures() {
        CustomVisionFloatingToolbarHandle strategy = new CustomVisionFloatingToolbarHandle();
        List<MenuGroup> features = new ArrayList<>();
        IToolbarMenuStrategy attendeeStrategy = strategy.getFloatingAttendeeToolbarMenuStrategy();
        features.add(new MenuGroup("悬浮窗与会者菜单", "buildAttendeeMenuItems", attendeeStrategy.buildMenuItems()));
        features.add(new MenuGroup("悬浮窗与会者更多菜单", "buildAttendeeMoreMenuItems", attendeeStrategy.buildMoreMenuItems()));
        IToolbarMenuStrategy audienceStrategy = strategy.getFloatingAudienceToolbarMenuStrategy();
        features.add(new MenuGroup("悬浮窗观众菜单", "buildAudienceMenuItems", audienceStrategy.buildMenuItems()));
        features.add(new MenuGroup("悬浮窗观众更多菜单", "buildAudienceMoreMenuItems", audienceStrategy.buildMoreMenuItems()));
        return features;
    }

    @NonNull
    @Override
    public String getFloatingMenuHandle() {
        return CustomVisionFloatingToolbarHandle.class.getName();
    }
}
