package com.huawei.hwmdemo.vision.dependency;

import android.util.Log;

import com.huawei.conflogic.HwmCallAllExternalAttendeesInfo;
import com.huawei.hwmbiz.BizNotificationHandler;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfBaseInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.HWMCorpConfigInfo;
import com.huawei.hwmconf.sdk.model.conf.entity.OperateExternalInviteeInfo;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.sdk.IConfListUpdate;
import com.huawei.hwmdemo.view.sdk.IPairCodeChangedListener;
import com.huawei.hwmlogger.HCLog;
import com.huawei.hwmsdk.enums.ConfRole;
import com.huawei.hwmsdk.enums.LoginState;
import com.huawei.hwmsdk.enums.ShareWatchingStatus;
import com.huawei.hwmsdk.enums.UserCorpInfoNotifyType;
import com.huawei.hwmsdk.model.result.AddAttendeeResultList;
import com.huawei.hwmsdk.model.result.AttendeeInfo;
import com.huawei.hwmsdk.model.result.ConfIncomingInfo;
import com.huawei.hwmsdk.model.result.RealTimeSubtitle;
import com.huawei.hwmsdk.model.result.ShareVmrInfo;
import com.huawei.hwmsdk.model.result.SubtitleRecordInfo;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CustomVisionBizNotificationHandle implements BizNotificationHandler {
    private static final String TAG = CustomVisionBizNotificationHandle.class.getSimpleName();

    private static final CopyOnWriteArrayList<IConfListUpdate> sConfListChangedListeners = new CopyOnWriteArrayList<>();
    private static final CopyOnWriteArrayList<IPairCodeChangedListener> sPairCodeChangedListeners = new CopyOnWriteArrayList<>();

    public static void registerConfListChangedListener(IConfListUpdate confListUpdate) {
        sConfListChangedListeners.add(confListUpdate);
    }

    public static void removeConfListChangedListener(IConfListUpdate confListUpdate) {
        sConfListChangedListeners.remove(confListUpdate);
    }

    public static void registerPairCodeChangedListener(IPairCodeChangedListener pairCodeChangedListener) {
        sPairCodeChangedListeners.add(pairCodeChangedListener);
    }

    public static void removePairCodeChangedListener(IPairCodeChangedListener pairCodeChangedListener) {
        sPairCodeChangedListeners.remove(pairCodeChangedListener);
    }

    //会议列表更新回调
    @Override
    public void onConfListChanged(List<ConfBaseInfo> hwmConfList) {
        // 更新频率高，存储日志,界面不提示
        HCLog.i(TAG, " onConfListChanged size : " + (hwmConfList == null ? 0 : hwmConfList.size()));
        for (IConfListUpdate listener : sConfListChangedListeners) {
            try {
                listener.onConfListUpdateNotify(hwmConfList);
            } catch (RuntimeException e) {
                Log.e(TAG, " onConfListChanged error : " + e);
            }
        }
    }

    @Override
    public void onIsSelfChairManChanged(boolean isChairman) {
    }

    @Override
    public void onAttendeeListChanged(List<AttendeeInfo> attendeeInfoList) {
    }

    @Override
    public void onWaitingListChanged(List<AttendeeInfo> waitingInfoList) {

    }

    @Override
    public void onRecordPermissionChanged(boolean hasPermission) {
    }

    @Override
    public void onBookConfSmsPermissionChanged(boolean hasPermission) {
    }

    @Override
    public void onAIConfRecordStateChanged(int state) {
    }

    @Override
    public void onRecordTypeChanged(int type) {
    }

    @Override
    public void onConfIncomingNotify(ConfIncomingInfo confIncomingInfo) {
    }

    @Override
    public void onSelfShareStateChanged(boolean isShare) {
        DemoUtil.showToast("BizNotificationHandler onSelfShareStateChanged : " + isShare);
    }

    @Override
    public void onWatchingShareStatusChanged(int userId, ShareWatchingStatus status) {
        DemoUtil.showToast("BizNotificationHandler onWatchingShareStatusChanged userId : " + +userId + " , status : " + status);
    }

    @Override
    public void onShareVmrInfoNotify(ShareVmrInfo shareVmrInfo) {
    }

    @Override
    public void onPairCodeChangedNotify(String pairCode) {
        HCLog.i(TAG, " onPairCodeChangedNotify pairCode : " + pairCode);
        DemoUtil.showToast("BizNotificationHandler onPairCodeChangedNotify : " + pairCode);
        for (IPairCodeChangedListener listener : sPairCodeChangedListeners) {
            try {
                listener.onPairCodeChanged(pairCode);
            } catch (RuntimeException e) {
                Log.e(TAG, " onPairCodeChangedNotify error : " + e);
            }
        }
    }

    @Override
    public void onOperateExternalAttendeeNotify(OperateExternalInviteeInfo operateExternalInviteeInfo) {

    }

    @Override
    public void onAddAttendeeNotify(AddAttendeeResultList resultList) {

    }

    @Override
    public void OnCallAllExternalAttendeesNotify(HwmCallAllExternalAttendeesInfo hwmCallAllExternalAttendeesInfo) {

    }

    @Override
    public void onSelfRoleChangedNotify(ConfRole confRole) {

    }

    @Override
    public void onWaitingRoomStateChanged(boolean isOpen) {

    }

    @Override
    public void onSubtitleStateChanged(boolean isOpen) {

    }

    @Override
    public void onCorpConfigNotify(HWMCorpConfigInfo corpConfigInfo) {

    }

    @Override
    public void OnUserCorpInfoNotify(UserCorpInfoNotifyType type) {

    }

    @Override
    public void onRealTimeSubtitleInfoNotify(RealTimeSubtitle realTimeSubtitle) {

    }

    @Override
    public void onSubtitleRecordNotify(SubtitleRecordInfo subtitleRecordInfo) {

    }

    @Override
    public void onLoginStateChangeNotify(LoginState loginState) {

    }
}
