package com.huawei.hwmdemo.vision.dependency.menu.participant;

import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.IParticipantMenuStrategy;
import com.huawei.hwmdemo.dependency.menu.item.CustomMoreMenu;
import com.huawei.hwmdemo.menu.ParticipantMenuCreator;
import com.huawei.hwmdemo.utils.DemoUtil;

import java.util.ArrayList;
import java.util.List;

public class CustomVisionParticipantMenuHandle implements IParticipantMenuStrategy {

    /**
     * 不支持定制，返回空集合
     */
    @Override
    public List<IConfMenu> buildParticipantMoreMenuItems() {
        return new ArrayList<>();
    }

    @Override
    public List<IConfMenu> buildParticipantItemMenuItems() {
        List<IConfMenu> confMenus = ParticipantMenuCreator.createParticipantItemMenus(DemoUtil.getApplication());
        //增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMenuItems() {
        return new ArrayList<>();
    }

    @Override
    public List<IConfMenu> buildWaitingToolbarMenuItems() {
        return new ArrayList<>();
    }

    @Override
    public List<IConfMenu> buildUnJoinedToolbarMenuItems() {
        return new ArrayList<>();
    }

    @Override
    public List<IConfMenu> buildParticipantToolbarMoreMenuItems() {
        List<IConfMenu> confMenus = ParticipantMenuCreator.createParticipantToolbarMoreItems(DemoUtil.getApplication());
        //增加一个自定义菜单
        confMenus.add(new CustomMoreMenu());
        return confMenus;
    }
}
