package com.huawei.hwmdemo.vision.dependency.menu.toolbar.listener;

import android.content.Intent;

import com.huawei.cloudlink.openapi.HWMSdk;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;
import com.huawei.hwmconf.presentation.dependency.menu.v2.OnMenuItemClickListener;
import com.huawei.hwmconf.sdk.model.conf.entity.AttendeeModel;
import com.huawei.hwmconf.sdk.model.conf.entity.ConfInfo;
import com.huawei.hwmdemo.R;
import com.huawei.hwmdemo.utils.DemoUtil;
import com.huawei.hwmdemo.view.sdkconfig.VisionAddAttendeesActivity;

public class CustomVisionOnMenuItemClickListener implements OnMenuItemClickListener {

    @Override
    public void onCustomMenuItemClick(IConfMenu confMenu, ConfInfo confInfo) {
        int menuId = confMenu.getId();
        if (menuId == R.id.conf_menu_vision_pair_code) {
            onClickVisionPairCode();
        } else if (menuId == R.id.hwmbizui_inmeeting_add_attendee_btn) {
            //演示自定义加人
            onClickCustomAddAttendee();
        } else if (menuId == R.id.conf_menu_custom) {
            DemoUtil.showToast("点击了自定义菜单");
        } else if (menuId == R.id.more_menu) {
            DemoUtil.showToast("点击了自定义更多菜单");
        }
    }

    @Override
    public void onCustomAttendeeMenuItemClick(IConfMenu confMenu, ConfInfo confInfo, AttendeeModel attendeeModel) {
        int menuId = confMenu.getId();
        if (menuId == R.id.conf_menu_custom) {
            DemoUtil.showToast("点击了与会者自定义菜单" + (attendeeModel == null ? "null" : attendeeModel.getName()));
        } else if (menuId == R.id.more_menu) {
            DemoUtil.showToast("点击了与会者自定义更多菜单" + (attendeeModel == null ? "null" : attendeeModel.getName()));
        }
    }

    private void onClickVisionPairCode() {
        String pairCode = HWMSdk.getOpenApi(DemoUtil.getApplication()).getPairCode();
        DemoUtil.showToast("大屏配对码：" + pairCode);
    }

    private void onClickCustomAddAttendee() {
        Intent intent = new Intent(DemoUtil.getApplication(), VisionAddAttendeesActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        DemoUtil.getApplication().startActivity(intent);
    }
}
