package com.huawei.hwmdemo.menu;

import android.content.Context;

import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.AllowOrCancelLocalRecordMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.AllowUnMuteMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.BroadcastOrCancelMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.CallOtherNumberMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.EnableWaitingRoomMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.HandsUpMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.HangUpMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.LockConfMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.MoveToWaitingRoomMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.MuteOrUnmuteMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.RecallMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.ReleaseOrRequestChairmanMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.RemoveMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.RenameMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.RequestHostMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.SelectWatchOrCancelMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.SetAsAudienceMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.SetChairmanMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.SetOrCancelCoHostMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.ShareLockMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.StartOrStopCameraMenu;
import com.huawei.cloudlink.smartrooms.uisdk.menu.participantitem.UnMuteAllMenu;
import com.huawei.hwmconf.presentation.dependency.menu.IConfMenu;

import java.util.ArrayList;
import java.util.List;

public class ParticipantMenuCreator {

    public static List<IConfMenu> createParticipantToolbarMoreItems(Context context) {
        List<IConfMenu> confMenus = new ArrayList<>();
        // 取消全场静音
        confMenus.add(new UnMuteAllMenu(context));
        // 锁定会议
        confMenus.add(new LockConfMenu(context));
        // 启动等候室
        confMenus.add(new EnableWaitingRoomMenu(context));
        // 允许与会者解除静音
        confMenus.add(new AllowUnMuteMenu(context));
        // 允许与会者共享
        confMenus.add(new ShareLockMenu(context));
        // 联席主持人申请主持人
        confMenus.add(new RequestHostMenu(context));
        return confMenus;
    }

    public static List<IConfMenu> createParticipantItemMenus(Context context) {
        List<IConfMenu> confMenus = new ArrayList<>();
        confMenus.add(new HandsUpMenu(context));
        confMenus.add(new MuteOrUnmuteMenu(context));
        confMenus.add(new SelectWatchOrCancelMenu(context));
        confMenus.add(new BroadcastOrCancelMenu(context));
        confMenus.add(new StartOrStopCameraMenu(context));
        // 分割线:AttendeeControlItemGroup.CONTROL_GROUP_SECOND;
        confMenus.add(new RenameMenu(context));
        confMenus.add(new AllowOrCancelLocalRecordMenu(context));
        confMenus.add(new ReleaseOrRequestChairmanMenu(context));
        confMenus.add(new SetAsAudienceMenu(context));
        confMenus.add(new SetChairmanMenu(context));
        confMenus.add(new SetOrCancelCoHostMenu(context));
        confMenus.add(new MoveToWaitingRoomMenu(context));
        confMenus.add(new RecallMenu(context));
        confMenus.add(new CallOtherNumberMenu(context));
        // 分割线:AttendeeControlItemGroup.CONTROL_GROUP_LEAVE;
        confMenus.add(new HangUpMenu(context));
        confMenus.add(new RemoveMenu(context));
        return confMenus;
    }

}
