package com.huawei.hwmdemo.vision.utils;

import android.content.Context;
import android.text.TextUtils;

import com.huawei.hwmdemo.model.ModeType;
import com.huawei.hwmfoundation.utils.PreferenceUtils;
import com.huawei.hwmlogger.HCLog;

import java.util.Arrays;
import java.util.List;

public class ModeUtil {

    private static final String TAG = "ModeUtil";

    private static final String KEY_MODE_TYPE = "KEY_MODE_TYPE";

    public static List<ModeType> getSupportedModeTypes() {
        return Arrays.asList(ModeType.MOBILE, ModeType.VISION);
    }

    public static ModeType getModeType(Context context) {
        ModeType currentModeType = ModeType.MOBILE;
        String selectedModeTypeStr = PreferenceUtils.read(PreferenceUtils.PREFERENCES_NAME, KEY_MODE_TYPE, ModeType.MOBILE.name(), context.getApplicationContext());
        for (ModeType modeType : ModeType.values()) {
            if (TextUtils.equals(modeType.name(), selectedModeTypeStr)) {
                currentModeType = modeType;
                break;
            }
        }
        HCLog.i(TAG, " getModeType : " + currentModeType);
        return currentModeType;
    }

    public static void setModeType(Context context, ModeType modeType) {
        HCLog.i(TAG, " setModeType : " + modeType);
        PreferenceUtils.save(PreferenceUtils.PREFERENCES_NAME, KEY_MODE_TYPE, modeType.name(), context.getApplicationContext());
    }
}
