﻿/**
* @file HwmUISDK.h
*
* Copyright(C), 2019-2020, Huawei Tech. Co., Ltd. ALL RIGHTS RESERVED.
*
* @brief [en] Interface file.
*        [cn] 接口文件
*/

#ifndef __HWM_PRIVATE_UISDK_H__
#define __HWM_PRIVATE_UISDK_H__

#include "HwmUISdkCommonDef.h"
#include "HwmPrivateUISdkMeetingService.h"
#include "HwmUISdk.h"
#include "HwmPrivateUISdkDef.h"

BEGIN_HWM_UISDK_NAMESPACE

/**
* @brief [en]This class is about PrivateUISDK
*        [cn]PrivateUISDK接口管理对象
* @GetInstance
*        HWM_UISDK_NAMESPACE::HwmPrivateUISDK
*
*/
class HWM_API HwmPrivateUISDK
{
public:
    /**
    * @brief [en] This interface is used to init sdk.
    *        [cn] 初始化（私有）
    *
    * @param initInfo [type:HwmInitPrivateInfo][cs_allowNull:N]
    *        [en]Init info
    *        [cn]初始化信息
    * @see HwmInitPrivateInfo
    *
    * @return [type:SDKERR]
    * @synchronized
    *
    * @win:disable
    **/
    static SDKERR InitPrivate(IN const HwmInitPrivateInfo* initInfo) { return SDKERR::UISDK_NOT_SUPPORT_END; };

    /**
    * @brief [en] This interface is used to get the Login service object.
    *        [cn] 获取登录服务对象
    *
    * @param NULL [cs_allowNull:Y]
    *
    * @retval IHwmLogin*        [en] If it's success return the pointer of class IHwmLogin.Otherwise,return HWM_NULL_PTR.
    *                           [cn] 成功返回 IHwmLogin     对象，失败返回 HWM_NULL_PTR
    *
    * @attention [en] NA
    *            [cn] NA
    *
    **/
    static IHwmPrivateMeeting* GetPrivateMeetingApi(HWM_VOID);
};

END_HWM_UISDK_NAMESPACE


#endif /* __HWM_PRIVATE_UISDK_H__ */